% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{switch_type}
\alias{switch_type}
\alias{coerce_type}
\alias{switch_class}
\alias{coerce_class}
\title{Dispatch on base types}
\usage{
switch_type(.x, ...)

coerce_type(.x, .to, ...)

switch_class(.x, ...)

coerce_class(.x, .to, ...)
}
\arguments{
\item{.x}{An object from which to dispatch.}

\item{...}{Named clauses. The names should be types as returned by
\code{\link[=type_of]{type_of()}}.}

\item{.to}{This is useful when you switchpatch within a coercing
function. If supplied, this should be a string indicating the
target type. A catch-all clause is then added to signal an error
stating the conversion failure. This type is prettified unless
\code{.to} inherits from the S3 class \code{"AsIs"} (see \code{\link[base:I]{base::I()}}).}
}
\description{
\code{switch_type()} is equivalent to
\code{\link[base]{switch}(\link{type_of}(x, ...))}, while
\code{switch_class()} switchpatches based on \code{class(x)}. The \code{coerce_}
versions are intended for type conversion and provide a standard
error message when conversion fails.
}
\section{Life cycle}{

\itemize{
\item Like \code{\link[=type_of]{type_of()}}, \code{switch_type()} and \code{coerce_type()} are
experimental functions.
\item \code{switch_class()} and \code{coerce_class()} are experimental functions.
}
}

\examples{
switch_type(3L,
  double = "foo",
  integer = "bar",
  "default"
)

# Use the coerce_ version to get standardised error handling when no
# type matches:
to_chr <- function(x) {
  coerce_type(x, "a chr",
    integer = as.character(x),
    double = as.character(x)
  )
}
to_chr(3L)

# Strings have their own type:
switch_type("str",
  character = "foo",
  string = "bar",
  "default"
)

# Use a fallthrough clause if you need to dispatch on all character
# vectors, including strings:
switch_type("str",
  string = ,
  character = "foo",
  "default"
)

# special and builtin functions are treated as primitive, since
# there is usually no reason to treat them differently:
switch_type(base::list,
  primitive = "foo",
  "default"
)
switch_type(base::`$`,
  primitive = "foo",
  "default"
)

# closures are not primitives:
switch_type(rlang::switch_type,
  primitive = "foo",
  "default"
)
}
\seealso{
\code{\link[=switch_lang]{switch_lang()}}
}
\keyword{internal}
