% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{cnd}
\alias{cnd}
\alias{error_cnd}
\alias{warning_cnd}
\alias{message_cnd}
\title{Create a condition object}
\usage{
cnd(.type = NULL, ..., .msg = NULL)

error_cnd(.type = NULL, ..., .msg = NULL)

warning_cnd(.type = NULL, ..., .msg = NULL)

message_cnd(.type = NULL, ..., .msg = NULL)
}
\arguments{
\item{.type}{The condition subclass.}

\item{...}{Named data fields stored inside the condition
object. These dots are evaluated with \link[=tidy-dots]{explicit
splicing}.}

\item{.msg}{A default message to inform the user about the
condition when it is signalled.}
}
\description{
These constructors make it easy to create subclassed conditions.
Conditions are objects that power the error system in R. They can
also be used for passing messages to pre-established handlers.
}
\details{
\code{cnd()} creates objects inheriting from \code{condition}. Conditions
created with \code{error_cnd()}, \code{warning_cnd()} and \code{message_cnd()}
inherit from \code{error}, \code{warning} or \code{message}.
}
\examples{
# Create a condition inheriting from the s3 type "foo":
cnd <- cnd("foo")

# Signal the condition to potential handlers. This has no effect if no
# handler is registered to deal with conditions of type "foo":
cnd_signal(cnd)

# If a relevant handler is on the current evaluation stack, it will be
# called by cnd_signal():
with_handlers(cnd_signal(cnd), foo = exiting(function(c) "caught!"))

# Handlers can be thrown or executed inplace. See with_handlers()
# documentation for more on this.


# Note that merely signalling a condition inheriting of "error" is
# not sufficient to stop a program:
cnd_signal(error_cnd("my_error"))

# you need to use stop() to signal a critical condition that should
# terminate the program if not handled:
# stop(error_cnd("my_error"))
}
\seealso{
\code{\link[=cnd_signal]{cnd_signal()}}, \code{\link[=with_handlers]{with_handlers()}}.
}
