% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob_num.R
\docType{data}
\name{prob}
\alias{prob}
\title{List current probability information.}
\format{An object of class \code{list} of length 10.}
\usage{
prob
}
\description{
\code{prob} is a list of named numeric variables
containing 3 essential (1 non-conditional and 2 conditional) probabilities
and 7 derived (1 non-conditional and 6 conditional) probabilities:
}
\details{
\enumerate{

\item the condition's prevalence \code{\link{prev}}
 (i.e., the probability of the condition being \code{TRUE}):
 \code{prev = \link{cond.true}/\link{N}}.

\item the decision's sensitivity \code{\link{sens}}
 (i.e., the conditional probability of a positive decision
 provided that the condition is \code{TRUE}).

\item the decision's miss rate \code{\link{mirt}}
 (i.e., the conditional probability of a negative decision
 provided that the condition is \code{TRUE}).

\item the decision's specificity \code{\link{spec}}
 (i.e., the conditional probability
 of a negative decision provided that the condition is \code{FALSE}).

\item the decision's false alarm rate \code{\link{fart}}
 (i.e., the conditional probability
 of a positive decision provided that the condition is \code{FALSE}).

\item the proportion (baseline probability or rate)
 of the decision being positive \code{\link{ppod}}
 (but not necessarily true):
 \code{ppod = \link{dec.pos}/\link{N}}.

\item the decision's positive predictive value \code{\link{PPV}}
(i.e., the conditional probability of the condition being \code{TRUE}
provided that the decision is positive).

\item the decision's false detection (or false discovery) rate \code{\link{FDR}}
(i.e., the conditional probability of the condition being \code{FALSE}
provided that the decision is positive).

\item the decision's negative predictive value \code{\link{NPV}}
(i.e., the conditional probability of the condition being \code{FALSE}
provided that the decision is negative).

\item the decision's false omission rate \code{\link{FOR}}
(i.e., the conditional probability of the condition being \code{TRUE}
provided that the decision is negative).

}

These probabilities are computed from basic probabilities
(contained in \code{\link{num}}) and computed by using
\code{\link{comp_prob}}.

The list \code{prob} is the probability counterpart
to the list containing frequency information \code{\link{freq}}.

Note that inputs of extreme probabilities (of 0 or 1)
may yield unexpected values (e.g., an \code{\link{NPV}}
value of NaN when \code{\link{is_extreme_prob_set}}
evaluates to \code{TRUE}).
}
\examples{
prob <- comp_prob()  # => initialize prob to default parameters
prob                 # => show current values
length(prob)         # => 8

}
\seealso{
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{txt}} contains current text information;
\code{\link{init_txt}} initializes text information;
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other lists containing current scenario information: \code{\link{accu}},
  \code{\link{freq}}, \code{\link{num}}, \code{\link{pal}},
  \code{\link{txt}}
}
\keyword{datasets}
