% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_accu.R
\name{comp_accu}
\alias{comp_accu}
\title{Compute acccuracy of current classification results.}
\usage{
comp_accu(hi = freq$hi, mi = freq$mi, fa = freq$fa, cr = freq$cr,
  w = 0.5)
}
\arguments{
\item{hi}{The number of hits \code{\link{hi}} (or true positives).}

\item{mi}{The number of misses \code{\link{mi}} (or false negatives).}

\item{fa}{The number of false alarms \code{\link{fa}} (or false positives).}

\item{cr}{The number of correct rejections \code{\link{cr}} (or true negatives).}

\item{w}{The weighting parameter \code{w} (from 0 to 1)
for computing weighted accuracy \code{wacc}.
Default: \code{w = .50} (i.e., yielding balanced accuracy \code{bacc}).}
}
\value{
A list \code{\link{accu}} containing current accuracy metrics.
}
\description{
\code{comp_accu} computes current accuracy metrics
from the 4 essential frequencies (\code{\link{hi}},
\code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}})
that constitute the current confusion matrix and
are contained in \code{\link{freq}}.
}
\details{
Currently computed metrics include:

\enumerate{

\item \code{acc}: Overall accuracy as the proportion (or probability)
   of correctly classifying cases or of \code{\link{dec.cor}} cases:

\code{acc = dec.cor/N = (hi + cr)/(hi + mi + fa + cr)}

Values range from 0 (no correct prediction) to 1 (perfect prediction).

\item \code{wacc}: Weighted accuracy, as a weighted average of the
   sensitivity \code{\link{sens}} (aka. hit rate \code{\link{HR}}, \code{\link{TPR}},
   \code{\link{power}} or \code{\link{recall}})
   and the the specificity \code{\link{spec}} (aka. \code{\link{TNR}})
   in which \code{\link{sens}} is multiplied by a weighting parameter \code{w}
   (ranging from 0 to 1) and \code{\link{spec}} is multiplied by
   \code{w}'s complement \code{(1 - w)}:

\code{wacc = (w * sens) + ((1 - w) * spec)}

If \code{w = .50}, \code{wacc} becomes \emph{balanced} accuracy \code{bacc}.

\item \code{mcc}: The Matthews correlation coefficient (with values ranging from -1 to +1):

\code{mcc = ((hi * cr) - (fa * mi)) / sqrt((hi + fa) * (hi + mi) * (cr + fa) * (cr + mi))}

A value of \code{mcc = 0} implies random performance; \code{mcc = 1} implies perfect performance.

See \href{https://en.wikipedia.org/wiki/Matthews_correlation_coefficient}{Wikipedia: Matthews correlation coefficient}
   for additional information.

\item \code{f1s}: The harmonic mean of the positive predictive value \code{\link{PPV}}
   (aka. \code{\link{precision}})
   and the sensitivity \code{\link{sens}} (aka. hit rate \code{\link{HR}},
   \code{\link{TPR}}, \code{\link{power}} or \code{\link{recall}}):

\code{f1s =  2 * (PPV * sens) / (PPV + sens)}

See \href{https://en.wikipedia.org/wiki/F1_score}{Wikipedia: F1 score} for additional information.

}

Note that some accuracy metrics can be interpreted
as probabilities (e.g., \code{acc}) or correlations (e.g., \code{mcc}).
}
\examples{
comp_accu()  # => computes accuracy metrics for current default scenario
comp_accu(hi = 1, mi = 2, fa = 3, cr = 4)  # medium accuracy, but cr > hi

# Extreme cases:
comp_accu(hi = 1, mi = 1, fa = 1, cr = 1)  # random performance
comp_accu(hi = 1, mi = 0, fa = 0, cr = 1)  # perfect accuracy/optimal performance
comp_accu(hi = 0, mi = 1, fa = 1, cr = 0)  # zero accuracy/worst performance, but see f1s
comp_accu(hi = 1, mi = 0, fa = 0, cr = 0)  # perfect accuracy, but see wacc and mcc

# Effects of w:
comp_accu(hi = 3, mi = 2, fa = 1, cr = 4, w = 1/2)  # equal weights to sens and spec
comp_accu(hi = 3, mi = 2, fa = 1, cr = 4, w = 2/3)  # more weight to sens
comp_accu(hi = 3, mi = 2, fa = 1, cr = 4, w = 1/3)  # more weight to spec


}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix}
for additional information.
}
\seealso{
The corresponding data frame ;
\code{\link{num}} for basic numeric parameters;
\code{\link{freq}} for current frequency information;
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings;
\code{\link{popu}} for a table of the current population.

Other metrics: \code{\link{accu}}, \code{\link{comp_acc}}

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_acc}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_prob}}, \code{\link{comp_sens}},
  \code{\link{comp_spec}}
}
