% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{coxDesign}
\alias{coxDesign}
\alias{coxDesign.coxph}
\alias{coxDesign.phreg}
\title{Extract the design matrix used to train a Cox model}
\usage{
coxDesign(object, center)

\method{coxDesign}{coxph}(object, center = FALSE)

\method{coxDesign}{phreg}(object, center = FALSE)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}

\item{center}{logical. Should the variable of the linear predictor be centered ?}
}
\description{
Extract the design matrix used to train a Cox model. Should contain the time of event, the type of event, 
the variable for the linear predictor, the strata variables and the date of entry (in case of delayed entry).
}
\author{
Brice Ozenne broz@sund.ku.dk
}
