% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iidCox.R
\name{iid}
\alias{iid}
\alias{iidCox}
\title{Extract i.i.d. decomposition from a Cox model}
\usage{
iidCox(object, newdata = NULL, tauHazard = NULL, keep.times = TRUE,
  store.iid = "full")
}
\arguments{
\item{object}{object The fitted Cox regression model object either
obtained with \code{coxph} (survival package) or \code{cph}
(rms package).}

\item{newdata}{Optional new data at which to do i.i.d. decomposition}

\item{tauHazard}{the vector of times at which the i.i.d decomposition of the baseline hazard will be computed}

\item{keep.times}{Logical. If \code{TRUE} add the evaluation times to the output.}

\item{store.iid}{the method used to compute the influence function and the standard error.
Can be \code{"full"}, \code{"approx"} or \code{"minimal"}. See the details section.}
}
\value{
A list containing:
 \itemize{
 \item{IFbeta}{Influence function for the regression coefficient.}
 \item{IFhazard}{Time differential of the influence function of the hazard.}
 \item{IFcumhazard}{Influence function of the cumulative hazard.}
 \item{calcIFhazard}{Elements used to compute the influence function at a given time.}
 \item{time}{Times at which the influence function has been evaluated.}
 \item{etime1.min}{Time of first event (i.e. jump) in each strata.}
 \item{etime.max}{Last observation time (i.e. jump or censoring) in each strata.}
 \item{indexObs}{Index of the observation in the original dataset.}
}
}
\description{
Compute the influence function for each observation used to estimate the model
}
\details{
If there is no event in a strata, the influence function for the baseline hazard is set to 0.

\code{store.iid} equal to \code{"full"} exports the influence function for the coefficients
and the baseline hazard at each event time.
\code{store.iid} equal to \code{"approx"} does the same except that the terms that do not contributes
to the variance are not ignored (i.e. set to 0)
\code{store.iid} equal to \code{"minimal"} exports the influence function for the coefficients. For the
baseline hazard it only computes the quantities necessary to compute the influence function in order to save memory.
}
\examples{
library(survival)
library(data.table)
set.seed(10)
d <- sampleData(100, outcome = "survival")[,.(eventtime,event,X1,X6)]
setkey(d, eventtime)

m.cox <- coxph(Surv(eventtime, event) ~ X1+X6, data = d, y = TRUE, x = TRUE)
system.time(IF.cox <- iidCox(m.cox))
system.time(IF.cox_approx <- iidCox(m.cox, store.iid = "approx"))


IF.cox <- iidCox(m.cox, tauHazard = sort(unique(c(7,d$eventtime))))
 

}
