% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{vietoris_rips}
\alias{vietoris_rips}
\title{Calculate Persistent Homology of a Point Cloud}
\usage{
vietoris_rips(
  dataset,
  dim = 1,
  threshold = -1,
  p = 2L,
  format = "cloud",
  standardize = FALSE,
  return_format = "df"
)
}
\arguments{
\item{dataset}{numeric matrix containing point cloud or distance matrix}

\item{dim}{maximum dimension of features to calculate}

\item{threshold}{maximum diameter for computation of Vietoris-Rips complexes}

\item{p}{number of the prime field Z/pZ to compute the homology over}

\item{format}{format of \code{mat}, either \code{"cloud"} for point cloud or \code{"distmat"} for distance matrix}

\item{standardize}{boolean determining whether point cloud size should be standardized}

\item{return_format}{defaults to \code{"df"}, returning a data frame;
if \code{mat}, returns a numeric matrix}
}
\value{
3-column matrix or data frame, with each row representing a TDA feature
}
\description{
Calculates the persistent homology of a point cloud, as represented by
a Vietoris-Rips complex. This function is an R wrapper for Ulrich Bauer's
Ripser C++ library for calculating persistent homology. For more
information on the C++ library, see \url{https://github.com/Ripser/ripser}.
}
\details{
The \code{mat} parameter should be a numeric matrix with each row corresponding
to a single point, and each column corresponding to a single dimension. Thus,
if \code{mat} has 50 rows and 5 columns, it represents a point cloud with 50 points
in 5 dimensions. The \code{dim} parameter should be a positive integer.
Alternatively, the \code{mat} parameter could be a distance matrix (upper
triangular half is ignored); note: \code{format} should be specified as "distmat".
}
\examples{

# create a 2-d point cloud of a circle (100 points)
num.pts <- 100
rand.angle <- runif(num.pts, 0, 2*pi)
pt.cloud <- cbind(cos(rand.angle), sin(rand.angle))

# calculate persistent homology (num.pts by 3 numeric matrix)
pers.hom <- vietoris_rips(pt.cloud)
}
