% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introjs.R
\name{introBox}
\alias{introBox}
\title{Generate intro elements in UI}
\usage{
introBox(..., data.step, data.intro, data.hint,
  data.position = c("bottom", "auto", "top", "left", "right", "bottom",
  "bottom-left_aligned", "bottom-middle-aligned", "bottom-right-aligned",
  "auto"))
}
\arguments{
\item{...}{Elements in introduction element}

\item{data.step}{a number indicating its spot in the order in the intro}

\item{data.intro}{text for introduction}

\item{data.hint}{text for clickable hints}

\item{data.position}{position of intro}
}
\description{
Wrap \code{introBox} around elements you want to include in introduction.
Use data.step to order the boxes and data.intro to specify the comment in the introduction
}
\examples{
\dontrun{
library(rintrojs)
library(shiny)
ui <- shinyUI(fluidPage(
  introjsUI(), # must include in UI
  mainPanel(
    introBox(
      tableOutput("mtcars"),
      data.step = 1,
      data.intro = "This is the table"
    ),
    introBox(
      actionButton("btn","Intro"),
      data.step = 2,
      data.intro = "This is the button"
    )
  )))
server <- shinyServer(function(input, output, session) {
  output$mtcars <- renderTable({
    head(mtcars)
  })
  observeEvent(input$btn,
               introjs(session))
})
# Run the application
shinyApp(ui = ui, server = server)
}
}
\seealso{
\code{\link[=introjsUI]{introjsUI()}} \code{\link[=introjs]{introjs()}}
}
