% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannon_cross_entropy}
\alias{shannon_cross_entropy}
\title{Shannon Cross Entropy}
\usage{
shannon_cross_entropy(p, q, b = 2)
}
\arguments{
\item{p}{Dist specifying the true distribution.}

\item{q}{Dist specifying the unnatural distribution.}

\item{b}{Numeric giving the base of the logarithm.}
}
\value{
Numeric giving the Shannon cross entropy.
}
\description{
Compute the base-\code{b} Shannon cross entropy between a true distribution
\code{p} and an unnatural distribution \code{q}.
}
\examples{
p <- Dist(c(1, 0, 0))
q <- Dist(c(2, 1, 1))
shannon_cross_entropy(p, q)               # 1.0000000
shannon_cross_entropy(q, p)               # Inf
shannon_cross_entropy(p, q, b = 3)        # 0.6309298
shannon_cross_entropy(q, p, b = 3)        # Inf


}
