% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airm.R
\name{airm_exp}
\alias{airm_exp}
\title{Compute the AIRM Exponential}
\usage{
airm_exp(sigma, v)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{v}{A tangent vector of class \code{dspMatrix}, to be mapped back to the manifold at \code{sigma}.}
}
\value{
A symmetric positive-definite matrix of class \code{dppMatrix}.
}
\description{
This function computes the Riemannian exponential map for the Affine-Invariant Riemannian Metric (AIRM).
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  sigma <- diag(2) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  v <- diag(c(1, 0.5)) |>
    Matrix::symmpart() |>
    Matrix::pack()
  airm_exp(sigma, v)
}
}
