% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orto_request.R
\name{orto_request}
\alias{orto_request}
\title{returns a data frame with metadata and links to the orthoimages in a given polygon}
\usage{
orto_request(polygon)
}
\arguments{
\item{polygon}{the polygon layer (may consist of n objects)}
}
\value{
a data frame with metadata and links to the orthoimages
}
\description{
returns a data frame with metadata and links to the orthoimages in a given polygon
}
\examples{
\dontrun{
library(sf)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)
req_df = orto_request(polygon)

# simple filtering by attributes
req_df = req_df[req_df$composition == "CIR", ]
req_df = req_df[req_df$resolution <= 0.25 & req_df$year >= 2016, ]
}
}
