% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets-generators.R
\name{sphere}
\alias{sphere}
\title{Sampling on the Sphere}
\usage{
sphere(n_samples, ambient_dim, radius = 1)
}
\arguments{
\item{n_samples}{An integer value specifying the sample size.}

\item{ambient_dim}{An integer value specifying the dimension of the ambient
space.}

\item{radius}{A numeric value specifying the radius of the sphere. Defaults
to \code{1.0}.}
}
\value{
A numeric array of shape \eqn{n_\mathrm{samples} \times
  \mathrm{ambient\_dim}} storing \code{n_samples} points uniformly sampled on the
sphere of dimension \code{ambient_dim - 1}.
}
\description{
The function \code{\link[=sphere]{sphere()}} enables uniform sampling of random \emph{i.i.d.} points on
a \eqn{(d-1)}-sphere in \eqn{R^d}. The user should provide the number of
points \code{n_samples} to be generated on the sphere and the ambient dimension
\code{ambient_dim}. The radius of the sphere is optional and is equal to \code{1} by
default. Only random points generation is currently available.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sphere(10, 2)
\dontshow{\}) # examplesIf}
}
