% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgraph6-package.R
\docType{package}
\name{rgraph6-package}
\alias{rgraph6-package}
\alias{_PACKAGE}
\alias{rgraph6}
\title{rgraph6: Representing Graphs as 'graph6', 'digraph6' or 'sparse6' Strings}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Encode network data as strings of printable ASCII characters. Implemented functions include encoding and decoding adjacency matrices, edgelists, igraph, and network objects to/from formats 'graph6', 'sparse6', and 'digraph6'. The formats and methods are described in McKay, B.D. and Piperno, A (2014) \doi{10.1016/j.jsc.2013.09.003}.
}
\details{
Formats 'graph6', 'sparse6' and 'digraph6' represent graphs as
strings of printable ASCII characters. The formats are due to \href{http://cs.anu.edu.au/~bdm}{Brendan McKay} who implemented them in his program
\code{Nauty} (McKay 1978, 1980, 2003, McKay & Piperno 2014), and are described
in detail \href{http://cs.anu.edu.au/people/bdm/data/formats.txt}{here}. Package
\pkg{rgraph6} is a native R implementation of these formats.

The main functions are \code{\link[=as_graph6]{as_graph6()}}, \code{\link[=as_digraph6]{as_digraph6()}}, \code{\link[=as_sparse6]{as_sparse6()}} for
encoding network data and \code{\link[=igraph_from_text]{igraph_from_text()}} and \code{\link[=network_from_text]{network_from_text()}} for
decoding. There are also other low-level functions to decode directly from
\link[=from_digraph6]{digraph6}, \link[=from_graph6]{graph6}, and
\link[=from_sparse6]{sparse6}.
}
\section{Citation}{


When using this package please cite it by referring to the following
publications:
McKay B, Piperno A (2014). "Practical graph isomorphism, II." \emph{Journal
of Symbolic Computation}, \emph{60}, 94-112.

Bojanowski M, Schoch D (2021). \emph{rgraph6: Representing Graphs as graph6,
dgraph6 or sparse6 Strings}. R package version: 2.0-0,
\url{https://mbojan.github.io/rgraph6/}.

Call \code{citation(package="rgraph6")} for more details and the BibTeX entry.
}

\references{
McKay, B. D. (1978) Computing automorphisms and canonical labellings of
graphs \emph{Combinatorial Mathematics, Lect. Notes Math.}, vol. 686,
Springer-Verlag, Berlin, pp. 223-232 \doi{10.1007/BFb0062536}

McKay, B. D. (1981). Practical graph isomorphism. \emph{Congressus Numerantium},
30, pp. 45-87

McKay, B. D. (2003). \emph{"Nauty" User’s Guide} (version 2.2) (p. 112). Technical
Report TR-CS-9002, Australian National University.

McKay, B. D., & Piperno, A. (2013). \emph{Nauty and Traces user’s guide} (Version
2.5). Computer Science Department, Australian National University, Canberra,
Australia.

McKay, B. D., & Piperno, A. (2014). Practical graph isomorphism, II. \emph{Journal
of symbolic computation}, 60, 94-112. \doi{10.1016/j.jsc.2013.09.003}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mbojan.github.io/rgraph6/}
  \item Report bugs at \url{https://github.com/mbojan/rgraph6/issues}
}

}
\author{
\strong{Maintainer}: Michal Bojanowski \email{michal2992@gmail.com} (\href{https://orcid.org/0000-0001-7503-852X}{ORCID}) (Kozminski University)

Authors:
\itemize{
  \item David Schoch \email{david@schochastics.net} (\href{https://orcid.org/0000-0003-2952-4812}{ORCID})
}

}
\keyword{package}
