% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/front_end.R
\name{reconstruct}
\alias{reconstruct}
\alias{reconstruct,matrix-method}
\alias{reconstruct,data.frame-method}
\alias{reconstruct,numeric-method}
\alias{reconstruct,character-method}
\alias{reconstruct,Spatial-method}
\alias{reconstruct,sf-method}
\title{Reconstruct geographic features}
\usage{
reconstruct(x, ...)

\S4method{reconstruct}{matrix}(
  x,
  age,
  model = "MERDITH2021",
  listout = TRUE,
  verbose = FALSE,
  enumerate = TRUE,
  chunk = 200,
  reverse = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = TRUE,
  partitioning = "static_polygons",
  check = TRUE
)

\S4method{reconstruct}{data.frame}(x, ...)

\S4method{reconstruct}{numeric}(x, ...)

\S4method{reconstruct}{character}(
  x,
  age,
  model = "MERDITH2021",
  listout = TRUE,
  verbose = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = FALSE,
  partitioning = "static_polygons",
  check = TRUE
)

\S4method{reconstruct}{Spatial}(
  x,
  age,
  model,
  listout = TRUE,
  verbose = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = FALSE,
  partitioning = "static_polygons",
  check = TRUE
)

\S4method{reconstruct}{sf}(
  x,
  age,
  model,
  listout = TRUE,
  verbose = FALSE,
  path.gplates = NULL,
  cleanup = TRUE,
  dir = NULL,
  plateperiod = FALSE,
  gmeta = FALSE,
  partitioning = "static_polygons",
  check = TRUE
)
}
\arguments{
\item{x}{are the features to be reconstructed. Can be a vector with longitude and latitude representing
a single point or a matrix/dataframe with the first column as longitude and second column as latitude, or a \code{SpatialPolygonsDataFrame} class object. 
For the online subroutine, the character strings \code{"static_polygons"}, \code{"coastlines"}  and \code{"plate_polygons"} return static plate polygons, rotated present-day coastlines and topological plates, respectively. For the offline subroutine, it can be a name of the feature set defined in the \code{model} object.}

\item{...}{arguments passed to class-specific methods.}

\item{age}{(\code{numeric}) is the age in Ma at which the points will be reconstructed}

\item{model}{(\code{character} or \code{\link{platemodel}}) The  reconstruction model. The class of this argument selects the submodule used for reconstruction, a \code{character} value will invoke the remote reconstruction submodule and will submit \code{x} to the GPlates Web Service. A \code{platemodel} class object will call the local-reconstruction submodule. The default is \code{"PALEOMAP"}. See details for available models.}

\item{listout}{(\code{logical})If multiple ages are given, the output can be returned as a \code{list} if \code{listout = TRUE}.}

\item{verbose}{(\code{logical}) Should call URLs (remote submodule) or console feedback (local-submodule) be printed?}

\item{enumerate}{(\code{logical}) Should be all coordinate/age combinations be enumerated and reconstructed (set to \code{TRUE} by default)? \code{FALSE} is applicable only if the number of rows in \code{x} is equal to the number elementes in \code{age}. Then a point will be reconstructed to the age that has the same index in \code{age} as the row of the coordinates in \code{x}. List output is not available in this case.}

\item{chunk}{(\code{numeric}) Argument of the remote reconstruction submodule. Single integer, the number of coordinates that will be queried from the GPlates in a single go.}

\item{reverse}{(\code{logical}) Argument of the remote reconstruction submodule. The flag to control the direction of reconstruction. If \code{reverse = TRUE}, the function will 
calculate the present-day coordinates of the given paleo-coordinates.}

\item{path.gplates}{(\code{character}) Argument of the local reconstruction submodule. In case the GPlates executable file is not found at the coded default location, the full path to the executable (gplates-<ver>.exe on Windows) can be entered here. e.g. \code{"C:/gplates_2.3.0_win64/gplates.exe"}.}

\item{cleanup}{(\code{logical}) Argument of the local reconstruction submodule. Should the temporary files be deleted immediately after reconstructions?}

\item{dir}{(\code{character}) Argument of the local reconstruction submodule. Directory where the temporary files of the reconstruction are stored (defaults to a temporary directory created by R). Remember to toggle \code{cleanup} if you want to see the files.}

\item{plateperiod}{(\code{logical}) Argument of the local reconstuction submodule. Should the durations of the plates be forced on the partitioned feature? If these are set to \code{TRUE} and the plate duration estimates are long, then you might lose some data.}

\item{partitioning}{(\code{character}) Argument of the local reconstruction submodule, which feature collection of the tectonic model should be used to assing plate IDs to the features? It defaults to \code{"static_polygons"}.}

\item{check}{(\code{logical}) Should the validity of the entries for the GWS checked with the information stored in \code{\link{gws}}? (default: \code{TRUE})}

\item{gmeta}{(\code{logical}) Argument of the local reconstruction submodule, in the case, when \code{sf} objects are supplied. Should the metadata produced by GPlates be included in the output object?}
}
\value{
A \code{numeric} matrix if \code{x} is a \code{numeric}, \code{matrix} or \code{data.frame}, or \code{Spatial*} class objects, depending on input. \code{NULL} in case no model is specified.
}
\description{
Reconstruct the geographic locations from present day coordinates and spatial objects back to their paleo-positions. 
Each location will be assigned a plate id and moved back in time using the chosen reconstruction model.
}
\details{
The function implements two reconstruction submodules, which are selected with the \code{model} argument:

If \code{model} is a \code{character} entry, then the \code{reconstruct()} function uses the GPlates Web Service (\url{https://gws.gplates.org/}, remote reconstruction submodule).
The available reconstruction models for this submodule are (as of 2023-06-29):
\itemize{
 \item "SETON2012" (Seton et al., 2012) for coastlines and topological plate polygons (0-200 Ma).
 \item "RODINIA2013" (Li et al., 2012) for coastlines (530-1100 Ma).
 \item "MULLER2016" (Muller et al., 2016) for coastlines and topological plate polygons (0-230 Ma).
 \item "GOLONKA" (Wright et al. 2013) for coastlines only (0-550 Ma). 
 \item "PALEOMAP" (Scotese, 2016) for coastlines only (0-1100 Ma). 
 \item "MATTHEWS2016_mantle_ref" (Matthews et al., 2016) for coastlines and topological plate polygons (0-410 Ma). 
 \item "MATTHEWS2016_pmag_ref" (Matthews et al., 2016) for coastlines and topological plate polygons (0-410 Ma).
 \item "MULLER2019" (Müller et al., 2019) for coastlines and static plate polygons. (0-250 Ma).
 \item "MERDITH2021" (Merdith et al., 2021, default) for coastlines and static plate polygons (0-1000 Ma). 
 \item "MULLER2022" (Müller et al., 2022) for coastlines and static plate polygons (0-1000 Ma). 
}

If \code{model} is a \code{\link{platemodel}} class object, then the function will try to use the GPLates desktop application (\url{https://www.gplates.org/}) to reconstruct the coordinates (local reconstruction submodule).
Plate models are available in chronosphere with the \code{\link[chronosphere]{fetch}} function. See \code{\link[chronosphere]{datasets}} for the available models.
The function will try to find the main GPlates executable in its default installation directory. If this does not succeed, use \code{path.gplates} to enter the full path to the GPlates executable as a \code{character} string.
}
\section{References}{

Matthews, K. J., Maloney, K. T., Zahirovic, S., Williams, S. E., Seton, M., & Müller, R. D. (2016). Global plate boundary evolution and kinematics since the late Paleozoic. Global and Planetary Change, 146, 226–250. https://doi.org/10.1016/j.gloplacha.2016.10.002
\cr
\cr Andrew S. Merdith, Simon E. Williams, Alan S. Collins, Michael G. Tetley, Jacob A. Mulder, Morgan L. Blades, Alexander Young, Sheree E. Armistead, John Cannon, Sabin Zahirovic, R. Dietmar Müller, (2021). Extending full-plate tectonic models into deep time: Linking the Neoproterozoic and the Phanerozoic, Earth-Science Reviews, Volume 214, 2021, 103477, ISSN 0012-8252, https://doi.org/10.1016/j.earscirev.2020.103477.
\cr
\cr Müller, R. D., Seton, M., Zahirovic, S., Williams, S. E., Matthews, K. J., Wright, N. M., … Cannon, J. (2016). Ocean Basin Evolution and Global-Scale Plate Reorganization Events Since Pangea Breakup. Annual Review of Earth and Planetary Sciences, 44(1), 107–138. https://doi.org/10.1146/annurev-earth-060115-012211
\cr
\cr  Müller, R. D., Zahirovic, S., Williams, S. E., Cannon, J., Seton, M., Bower, D. J., Tetley, M. G., Heine, C., Le Breton, E., Liu, S., Russell, S. H. J., Yang, T., Leonard, J., and Gurnis, M. (2019), A global plate model including lithospheric deformation along major rifts and orogens since the Triassic. Tectonics, vol. 38, https://doi.org/10.1029/2018TC005462.
\cr
\cr Müller, R. D., Flament, N., Cannon, J., Tetley, M. G., Williams, S. E., Cao, X., Bodur, Ö. F., Zahirovic, S., and Merdith, A.: A tectonic-rules-based mantle reference frame since 1 billion years ago – implications for supercontinent cycles and plate–mantle system evolution, Solid Earth, 13, 1127–1159, https://doi.org/10.5194/se-13-1127-2022, 2022.
\cr
\cr Scotese, C. R. (2016). PALEOMAP PaleoAtlas for GPlates and the PaleoData Plotter Program. http://www.earthbyte.org/paleomap‐ paleoatlas‐for‐gplates
\cr
\cr Seton, M., Müller, R. D., Zahirovic, S., Gaina, C., Torsvik, T., Shephard, G., … Chandler, M. (2012). Global continental and ocean basin reconstructions since 200Ma. Earth-Science Reviews, 113(3–4), 212–270. https://doi.org/10.1016/j.earscirev.2012.03.002
\cr
\cr Wright, N., Zahirovic, S., Müller, R. D., & Seton, M. (2013). Towards community-driven paleogeographic reconstructions: integrating open-access paleogeographic and paleobiology data with plate tectonics. Biogeosciences, 10(3), 1529–1541. https://doi.org/10.5194/bg-10-1529-2013
}

\examples{
# With the web service 
# simple matrices
# replace model with desired choice
reconstruct(matrix(c(95, 54), nrow=1), 140, model=NULL)

# points reconstruction
xy <-cbind(long=c(95,142), lat=c(54, -33))
reconstruct(xy, 140, model=NULL)

}
