% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_gnparser.R
\name{install_gnparser}
\alias{install_gnparser}
\title{Install gnparser}
\usage{
install_gnparser(version = "latest", force = FALSE)
}
\arguments{
\item{version}{The gnparser version number, e.g., \verb{0.14.1}; the default
\code{latest} means the latest version (fetched from GitLab releases).
Alternatively, this argument can take a file path of the zip archive or
tarball of gnparser that has already been downloaded from GitLab,
in which case it will not be downloaded again.}

\item{force}{Whether to install gnparser even if it has already been installed.
This may be useful when upgrading gnparser.}
}
\description{
Download the appropriate gnparser executable for your platform and
try to copy it to a system directory so \pkg{rgnparser} can run the
\code{gnparser} command.
}
\details{
This function tries to install gnparser to \code{Sys.getenv('APPDATA')} on
Windows, \verb{~/Library/Application Support} on macOS, and \verb{~/bin/} on
other platforms (such as Linux). If these directories are not writable, the
package directory \code{gnparser} of \pkg{rgnparser} will be used. If it
still fails, you have to install gnparser by yourself and make sure it can
be found via the environment variable \code{PATH}.

This is just a helper function and may fail to choose the correct gnparser
executable for your operating system, especially if you are not on Windows
or Mac or a major Linux distribution. When in doubt, read the gnparser
documentation and install it yourself:
https://gitlab.com/gogna/gnparser#installation
}
\note{
modified from \code{blogdown::install_hugo}
}
