% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.orthoview.R
\name{rgl.orthoview}
\alias{rgl.orthoview}
\title{Display orthogonal projection}
\usage{
rgl.orthoview(plane = "xy", fov = 0, ...)
}
\arguments{
\item{plane}{character string, which can be either of `xy`, `yx`, `yz`, `zy`, `zx`, `xz`, where the  first letter is the axis displayed from left to right and the second letter is the axis displayed from bottom to top. The third axis points either out of the screen or into the screen following the right-hand convention.}

\item{fov}{field of view in degrees, as used in \code{\link[rgl]{rgl.viewpoint}}.}

\item{...}{additional arguments for \code{\link[rgl]{rgl.viewpoint}}.}
}
\value{
None
}
\description{
Display orthogonal projection on principal Cartesian planes, with scene centre in the image centre.
}
\examples{
rgl::plot3d(array(runif(60),c(20,3)), col=rainbow(20), axes=FALSE,
            xlim=c(0,1), ylim=c(0,1), zlim=c(0,1), xlab='', ylab='', zlab='')
rgl::box3d()
rgl.orthoview('xy', fov=20)

}
\seealso{
\code{\link{rgl.camera}}
}
\author{
Danail Obreschkow
}
