\name{rgl.primitive}
\alias{rgl.primitive}
\alias{rgl.points}
\alias{rgl.lines}
\alias{rgl.linestrips}
\alias{rgl.triangles}
\alias{rgl.quads}
\title{Add primitive set shape}
\description{
Adds a shape node to the current scene.  These low-level
functions should not normally be called by users.
}
\usage{
rgl.points(x, y = NULL, z = NULL, ... )
rgl.lines(x, y = NULL, z = NULL, ... )
rgl.linestrips(x, y = NULL, z = NULL, ...)
rgl.triangles(x, y = NULL, z = NULL, normals = NULL, texcoords = NULL, ... )
rgl.quads(x, y = NULL, z = NULL, normals = NULL, texcoords = NULL, ... )
}
\arguments{
  \item{x, y, z}{coordinates.  Any reasonable way of defining the
    coordinates is acceptable.  See the function \code{\link[grDevices]{xyz.coords}}
    for details.}
  \item{normals}{Normals at each point.}
  \item{texcoords}{Texture coordinates at each point.}
  \item{ ... }{Material properties (see \code{\link{rgl.material}} for details) or \code{indices} (see the note below).}  
}
\details{
  Adds a shape node to the scene. The appearance is defined by the material properties.
  See \code{\link{rgl.material}} for details.
  
  The names of these functions correspond to OpenGL primitives.  They
  all take a sequence of vertices in \code{x, y, z}.  The only non-obvious 
  ones are \code{rgl.lines} which draws line segments based on
  pairs of vertices, and \code{rgl.linestrips} which joins the
  vertices.
  
  For triangles and quads, the normals at each vertex may be specified
  using \code{normals}.  These may be given in any way that would be
  acceptable as a single argument to \code{\link[grDevices]{xyz.coords}}.  
  These need not match the actual normals to the polygon:
  curved surfaces can be simulated by using other choices of normals.
  
  Texture coordinates may also be specified.  These may be given in
  any way that would be acceptable as a single argument to 
  \code{\link[grDevices]{xy.coords}}, and are interpreted in terms
  of the bitmap specified as the material texture, with \code{(0, 0)} 
  at the lower left, \code{(1, 1)} at the upper right.  The texture
  is used to modulate the color of the polygon.
  
  These are the lower level functions called by
  \code{\link{points3d}}, \code{\link{segments3d}},
  \code{\link{lines3d}}, etc.  The two principal differences between
  the \code{rgl.*} functions and the \code{*3d} functions are that the
  former set all unspecified material properties to defaults, whereas
  the latter use current values as defaults; the former make
  persistent changes to material properties with each call, whereas
  the latter make temporary changes only for the duration of the call.
}
\note{
All of these functions support an argument called
\code{indices}, which allows vertices (and other attributes)
to be re-used, as they are in objects created by \code{\link{mesh3d}} and related functions.  This is
intended to be used on smooth surfaces, where each shared
vertex has just one value for normals, colors and texture
coordinates.  

For shapes with flat-looking faces (e.g. polyhedra like \code{\link{cube3d}}),
the vertices \bold{must} be duplicated
to be rendered properly.
}
\value{
   Each primitive function returns the integer object ID of the shape that
   was added to the scene.  These can be passed to \code{\link{pop3d}}
   to remove the object from the scene.
}
\keyword{internal}
