% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_utils.R
\name{ee_utils_pyfunc}
\alias{ee_utils_pyfunc}
\title{Wrap an R function in a Python function with the same signature.}
\usage{
ee_utils_pyfunc(f)
}
\arguments{
\item{f}{An R function}
}
\value{
A Python function that calls the R function \code{f} with the same
signature.
}
\description{
This function could wrap an R function in a Python
function with the same signature. Note that the signature of the
R function must not contain esoteric Python-incompatible constructs.
}
\note{
\code{\link[reticulate]{py_func}} has been renamed to ee_utils_pyfunc
just to maintain the rgee functions name's style. All recognition
for this function must always be given to \pkg{reticulate}.
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

# Earth Engine List
ee_SimpleList <- ee$List$sequence(0, 12)
ee_NewList <- ee_SimpleList$map(
  ee_utils_pyfunc(
    function(x) {
      ee$Number(x)$add(x)
    }
  )
)

ee_NewList$getInfo()

# Earth Engine ImageCollection
constant1 <- ee$Image(1)
constant2 <- ee$Image(2)
ee_ic <- ee$ImageCollection(c(constant2, constant1))
ee_newic <- ee_ic$map(
  ee_utils_pyfunc(
    function(x) ee$Image(x)$add(x)
  )
)
ee_newic$mean()$getInfo()$type
}
}
\seealso{
Other ee_utils functions: 
\code{\link{ee_utils_py_to_r}()},
\code{\link{ee_utils_shp_to_zip}()}
}
\author{
Yuan Tang and J.J. Allaire
}
\concept{ee_utils functions}
