% Generated by roxygen2 (4.0.2): do not edit by hand
\name{organizations}
\alias{organizations}
\title{Organizations metadata.}
\usage{
organizations(data = "all", uuid = NULL, query = NULL, limit = 100,
  start = NULL, ...)
}
\arguments{
\item{data}{The type of data to get. Default is all data.}

\item{uuid}{UUID of the data node provider. This must be specified if data
is anything other than 'all'.}

\item{query}{Query nodes. Only used when data='all'}

\item{limit}{Number of records to return. Defaults: For \code{\link{occ_search}} 500, for others
100. Maximum: 1,000,000 records for \code{\link{occ_search}}, others, don't know yet.}

\item{start}{Record number to start at. Use in combination with limit to page through results.
Note that in \code{\link{occ_search}} we do the paging internally for you, so there's no
\code{start} parameeter, but in other functions you have to do paging yourself.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\value{
A list of length one or two. If \code{uuid} is NULL, then a data.frame with
call metadata, and a data.frame, but if \code{uuid} given, then a list.
}
\description{
Organizations metadata.
}
\examples{
\dontrun{
organizations(limit=5)
organizations(query="france")
organizations(uuid="4b4b2111-ee51-45f5-bf5e-f535f4a1c9dc")
organizations(data='contact', uuid="4b4b2111-ee51-45f5-bf5e-f535f4a1c9dc")
organizations(data='pending')
organizations(data=c('contact','endpoint'), uuid="4b4b2111-ee51-45f5-bf5e-f535f4a1c9dc")

# Pass on options to httr
library('httr')
res <- organizations(query="spain", config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/registry#organizations}
}

