% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotImpVarDist.R
\name{plotImpVarDist}
\alias{plotImpVarDist}
\title{Plot Important Variable Distribution}
\usage{
plotImpVarDist(rf, df, class.col, max.vars = 16, plot = TRUE)
}
\arguments{
\item{rf}{an object inheriting from \code{\link{randomForest}}.}

\item{df}{data.frame with predictors in \code{rf} model.}

\item{class.col}{response column name in \code{df}.}

\item{max.vars}{number of variables to plot (from most important to least).}

\item{plot}{display the plot?}
}
\value{
the \code{ggplot2} object is invisibly returned.
}
\description{
Plot distribution of predictor variables on classes sorted 
  by order of importance in model.
}
\note{
If the model in \code{rf} was run with \code{importance = TRUE}, then
  'MeanDecreaseAccuracy' is used as the importance measure. Otherwise,
  'MeanDecreaseGini' is used.
}
\examples{
data(mtcars)
df <- mtcars
df$am <- factor(df$am)

rf <- randomForest(am ~ ., df, importance = TRUE)
plotImpVarDist(rf, df, "am")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
