% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_survey_item.R
\name{document_survey_item}
\alias{document_survey_item}
\title{Document survey item harmonization}
\usage{
document_survey_item(x)
}
\arguments{
\item{x}{A labelled_spss_survey vector from a single survey
or concatenated from several surveys.}
}
\value{
Returns a list of the current and historic coding, labelling
of the valid range and missing values or range, the history of the 
variable names and the history of the survey IDs.
}
\description{
Document survey item harmonization
}
\examples{
var1 <- labelled::labelled_spss(
x = c(1,0,1,1,0,8,9), 
labels = c("TRUST" = 1, 
           "NOT TRUST" = 0, 
           "DON'T KNOW" = 8, 
           "INAP. HERE" = 9), 
na_values = c(8,9))

var2 <- labelled::labelled_spss(
  x = c(2,2,8,9,1,1 ), 
  labels = c("Tend to trust" = 1, 
             "Tend not to trust" = 2, 
             "DK" = 8, 
             "Inap" = 9), 
  na_values = c(8,9))

h1 <- harmonize_values (
  x = var1, 
  harmonize_label = "Do you trust the European Union?",
harmonize_labels = list ( 
    from = c("^tend\\\\sto|^trust", "^tend\\\\snot|not\\\\strust", "^dk|^don", "^inap"), 
    to = c("trust", "not_trust", "do_not_know", "inap"),
  numeric_values = c(1,0,99997, 99999)), 
na_values = c("do_not_know" = 99997,
              "inap" = 99999), 
  id = "survey1",
)

h2 <- harmonize_values (
  x = var2, 
  harmonize_label = "Do you trust the European Union?",
  harmonize_labels = list ( 
    from = c("^tend\\\\sto|^trust", "^tend\\\\snot|not\\\\strust", "^dk|^don", "^inap"), 
    to = c("trust", "not_trust", "do_not_know", "inap"),
    numeric_values = c(1,0,99997, 99999)), 
  na_values = c("do_not_know" = 99997,
                "inap" = 99999), 
  id = "survey2"
)

h3 <- concatenate(h1, h2) 
document_survey_item(h3)
}
\seealso{
Other documentation functions: 
\code{\link{document_waves}()}
}
\concept{documentation functions}
