% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flush_o2.R
\encoding{UTF-8}
\name{flush_o2}
\alias{flush_o2}
\title{Estimate dissolved O2 after a flush}
\usage{
flush_o2(resp_vol, flow_rate, duration, resp_o2, flush_o2)
}
\arguments{
\item{resp_vol}{volume of the respirometer (liter).}

\item{flow_rate}{rate of water flow into the respirometer (liters / minute).}

\item{duration}{duration of the flush (minutes).}

\item{resp_o2}{O2 inside the respirometer before the flush (units do not matter as long as it is consistant with \code{flush_o2}).}

\item{flush_o2}{O2 of the water used for flushing the respirometer (units do not matter as long as it is consistant with \code{resp_o2}).}
}
\value{
The dissolved O2 in the respirometer after the flush.
}
\description{
Given the dissolved O2 inside the respirometer and in the flush reservoir, the new pO2 or [O2] in the respirometer after the flush is estimated.
}
\examples{
# What will be the pO2 in the respirometer after this flush?
flush_o2(resp_vol = 90, flow_rate = 10, duration = 3, resp_o2 = 15, flush_o2 = 21)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\seealso{
\code{\link{flush_water}}, \code{\link{flush_carb}}
}

