% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{rscd_mapplot}
\alias{rscd_mapplot}
\title{Create a map of the provided variable on the RESOURCECODE field grid}
\usage{
rscd_mapplot(
  z,
  name = "Depth (m)",
  zlim = NULL,
  palette = "YlOrRd",
  direction = 1,
  transform = "identity"
)
}
\arguments{
\item{z}{the data ro plot: a vector of the same size as the grid (328,030 rows).}

\item{name}{name of the variable plored, to be included in the legend.}

\item{zlim}{limits of the scale. See \code{\link[ggplot2]{continuous_scale}} for details.}

\item{palette}{If a string, will use that named palette.
See \code{\link[ggplot2]{scale_colour_brewer}} for other options.}

\item{direction}{Sets the order of colours in the scale.
See \code{\link[ggplot2]{scale_colour_brewer}} for details.}

\item{transform}{Transformation to apply to the color scale.
See \code{\link[ggplot2]{continuous_scale}} for details.}
}
\value{
a ggplot2 object
}
\description{
Create a map of the provided variable on the RESOURCECODE field grid
}
\examples{
# Ensure that data package is available before running the example.
# If it is not, see the `resourcecode` package vignette for details
# on installing the required data package.
if (requireNamespace("resourcecodedata", quietly = TRUE)) {
rscd_mapplot(resourcecodedata::rscd_field$depth)
}
}
