% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_stats.R
\name{weighted_tabulate}
\alias{weighted_tabulate}
\title{Compute weighted tabulations}
\usage{
weighted_tabulate(bin, w, nbins = max(1L, bin, na.rm = TRUE))
}
\arguments{
\item{bin}{An integer vector with values from \code{1L} to \code{nbins}}

\item{w}{Weights per entry in \code{bin}.}

\item{nbins}{Number of bins}
}
\value{
A vector with length \code{nbins} where the \code{i}th result is equal to
\code{sum(w[bin == i])} or \code{sum(bin == i)} if \code{w} is missing.
For integer weights, this is equivalent to \code{tabulate(rep(bin, w), nbins)}.
}
\description{
Computes the sum of \code{w} grouped by \code{bin}.
If \code{w} is missing the result is equivalent to
\code{\link[base:tabulate]{tabulate(bin, nbins)}}
}
\examples{
weighted_tabulate(c(1, 1, 2))
weighted_tabulate(c(1, 1, 2), nbins = 3L)
weighted_tabulate(c(1, 1, 2), w = c(0.5, 0.5, 1), nbins = 3L)
}
\seealso{
Other weighted statistics: 
\code{\link{weighted_moments}()},
\code{\link{weighted_quantile}()}
}
\concept{weighted statistics}
