% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trunc_obs.R
\name{trunc_obs}
\alias{trunc_obs}
\alias{as_trunc_obs}
\alias{truncate_obs}
\alias{repdel_obs}
\title{Define a set of truncated observations}
\usage{
trunc_obs(x, xmin = x, xmax = x, tmin = -Inf, tmax = Inf, w = 1)

as_trunc_obs(.data)

truncate_obs(.data, tmin_new = -Inf, tmax_new = Inf, .partial = FALSE)

repdel_obs(.data, accident, delay, time, .truncate = FALSE)
}
\arguments{
\item{x}{Observations}

\item{xmin, xmax}{Censoring bounds. If \code{xmin != xmax}, \code{x} must be \code{NA}.}

\item{tmin, tmax}{Truncation bounds. May vary per observation.}

\item{w}{Case weights}

\item{.data}{A data frame or numeric vector.}

\item{tmin_new}{New truncation minimum}

\item{tmax_new}{New truncation maximum}

\item{.partial}{Enable partial truncation of censored observations?
This could potentially create inconsistent data if the actual observation
lies outside of the truncation bounds but the censoring interval overlaps.}

\item{accident}{accident time (unquoted, evaluated in \code{.data})}

\item{delay}{reporting delay (unquoted, evaluated in \code{.data})}

\item{time}{evaluation time (unquoted, evaluated in \code{.data})}

\item{.truncate}{Should claims reported after \code{time} be silently discarded?
If there are claims reported after \code{time} and \code{.truncate} is \code{FALSE},
an error will be raised.}
}
\value{
\strong{trunc_obs}: A \code{trunc_obs} tibble with columns \code{x}, \code{xmin}, \code{xmax},
\code{tmin} and \code{tmax} describing possibly interval-censored observations with
truncation

\code{as_trunc_obs} returns a \code{trunc_obs} tibble.

\code{truncate_obs} returns a \code{trunc_obs} tibble with possibly fewer
observations than \code{.data} and updated truncation bounds.

\code{repdel_obs} returns a \code{trunc_obs} tibble corresponding to the reporting
delay observations of each claim. If \code{.truncate} is \code{FALSE}, the result is
guaranteed to have the same number of rows as \code{.data}.
}
\description{
If \code{x} is missing, both \code{xmin} and \code{xmax} must be specified.
}
\details{
Uncensored observations must satisfy \code{tmin <= xmin = x = xmax <= tmax}.
Censored observations must satisfy \verb{tmin <= xmin < xmax <= tmax} and \code{x = NA}.
}
\examples{
N <- 100
x <- rexp(N, 0.5)

# Random, observation dependent truncation intervals
tmin <- runif(N, 0, 1)
tmax <- tmin + runif(N, 1, 2)

oob <- x < tmin | x > tmax
x <- x[!oob]
tmin <- tmin[!oob]
tmax <- tmax[!oob]

# Number of observations after truncation
N <- length(x)

# Randomly interval censor 30\% of observations
cens <- rbinom(N, 1, 0.3) == 1L
xmin <- x
xmax <- x
xmin[cens] <- pmax(tmin[cens], floor(x[cens]))
xmax[cens] <- pmin(tmax[cens], ceiling(x[cens]))
x[cens] <- NA

trunc_obs(x, xmin, xmax, tmin, tmax)

as_trunc_obs(c(1, 2, 3))
as_trunc_obs(data.frame(x = 1:3, tmin = 0, tmax = 10))
as_trunc_obs(data.frame(x = c(1, NA), xmin = c(1, 2), xmax = c(1, 3)))
truncate_obs(1:10, tmin_new = 2.0, tmax_new = 8.0)
}
