% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resemble.R
\docType{package}
\name{resemble-package}
\alias{resemble}
\alias{resemble-package}
\title{Overview of the functions in the resemble package}
\description{
This is the version \code{1.2.0} (\code{'alma-de-coco'}) of the package. It 
implements a number of \code{R} functions useful for 
modeling complex visible and infrared spectra (\acronym{vis-IR}). 
The package includes functions for projecting spectral data 
onto orthogonal spaces, computing spectral dissimilarity
matrices, removing irrelevant spectra from a reference set, 
and modeling spectral data using memory-based learning.
}
\details{
The functions available for projecting the spectra are:
\itemize{
  \item{\code{\link{orthoProjection}}} 
  \item{\code{\link{pcProjection}}} 
  \item{\code{\link{plsProjection}}} 
  \item{\code{\link{predict.orthoProjection}}} 
  }
The functions available for computing similarity/dissimilarity 
matrices are:
\itemize{
  \item{\code{\link{fDiss}}} 
  \item{\code{\link{corDiss}}} 
  \item{\code{\link{sid}}} 
  \item{\code{\link{orthoDiss}}} 
  }
The functions available for evaluating similarity/dissimilarity 
matrices are:
\itemize{
  \item{\code{\link{simEval}}} 
  }
The functions available for removing irrelevant spectra from a 
reference set are:
\itemize{
  \item{\code{\link{neigCleaning}}} 
  }
The functions available for modeling spectral data using 
memory-based learning are:
\itemize{
  \item{\code{\link{mblControl}}}
  \item{\code{\link{mbl}}} 
  }
Other supplementary functions are:
\itemize{
  \item{\code{\link{print.localOrthoDiss}}}
  \item{\code{\link{print.mbl}}}
  \item{\code{\link{plot.mbl}}}
  \item{\code{\link{plot.orthoProjection}}}
  \item{\code{\link{print.orthoProjection}}}
  }
}
\author{
Leonardo Ramirez-Lopez \email{ramirez.lopez.leo@gmail.com} & Antoine Stevens
}

