% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{RandMatContinuous}
\alias{RandMatContinuous}
\title{Create a Random Matrix: Continuous}
\usage{
RandMatContinuous(p, d, sparsity, catMap = NULL, ...)
}
\arguments{
\item{p}{the number of dimensions.}

\item{d}{the number of desired columns in the projection matrix.}

\item{sparsity}{a real number in \eqn{(0,1)} that specifies the distribution of non-zero elements in the random matrix.}

\item{catMap}{a list specifying specifies which one-of-K encoded columns in X correspond to the same categorical feature.}

\item{...}{used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{RerF}}.
}
\description{
Create a Random Matrix: Continuous
}
\examples{

p <- 8
d <- 3
sparsity <- 0.25
set.seed(4)
(a <- RandMatContinuous(p, d, sparsity))
}
