% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandMat.R
\name{RandMatCustom}
\alias{RandMatCustom}
\title{Create a Random Matrix: custom}
\usage{
RandMatCustom(p, d, nnzSample, nnzProb, ...)
}
\arguments{
\item{p}{the number of dimensions.}

\item{d}{the number of desired columns in the projection matrix.}

\item{nnzSample}{a vector specifying the number of non-zeros to
sample at each \code{d}.  Each entry should be less than \code{p}.}

\item{nnzProb}{a vector specifying probabilities in one-to-one correspondance
with \code{nnzSample}.}

\item{...}{used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{RerF}}.
}
\description{
Create a Random Matrix: custom
}
\examples{

p <- 28
d <- 8
nnzSample <- 1:8
nnzProb <- 1 / 36 * 1:8
paramList <- list(p = p, d = d, nnzSample, nnzProb)
set.seed(8)
(a <- do.call(RandMatCustom, paramList))
}
