% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildTree.R
\name{BuildTree}
\alias{BuildTree}
\title{RerF Tree Generator}
\usage{
BuildTree(X, Y, min.parent, max.depth, bagging, replacement, stratify,
  class.ind, class.ct, fun, mat.options, store.oob, store.ns, progress, rotate)
}
\arguments{
\item{X}{an n by d numeric matrix (preferable) or data frame. The rows correspond to observations and columns correspond to features.}

\item{Y}{an n length vector of class labels.  Class labels must be integer or numeric and be within the range 1 to the number of classes.}

\item{min.parent}{the minimum splittable node size.  A node size < min.parent will be a leaf node. (min.parent = 6)}

\item{max.depth}{the longest allowable distance from the root of a tree to a leaf node (i.e. the maximum allowed height for a tree).  If max.depth=0, the tree will be allowed to grow without bound.  (max.depth=0)}

\item{bagging}{a non-zero value means a random sample of X will be used during tree creation.  If replacement = FALSE the bagging value determines the percentage of samples to leave out-of-bag.  If replacement = TRUE the non-zero bagging value is ignored. (bagging=.2)}

\item{replacement}{if TRUE then n samples are chosen, with replacement, from X. (replacement=TRUE)}

\item{stratify}{if TRUE then class sample proportions are maintained during the random sampling.  Ignored if replacement = FALSE. (stratify = FALSE).}

\item{class.ind}{a vector of lists.  Each list holds the indexes of its respective class (e.g. list 1 contains the index of each class 1 sample).}

\item{class.ct}{a cumulative sum of class counts.}

\item{fun}{a function that creates the random projection matrix. (fun=NULL)}

\item{mat.options}{a list of parameters to be used by fun. (mat.options=c(ncol(X), round(ncol(X)^.5),1L, 1/ncol(X)))}

\item{store.oob}{if TRUE then the samples omitted during the creation of a tree are stored as part of the tree.  This is required to run OOBPredict(). (store.oob=FALSE)}

\item{store.ns}{if TRUE then the number of training observations at each node is stored. This is required to run FeatureImportance() (store.ns=FALSE) (store.ns=FALSE)}

\item{progress}{if true a pipe is printed after each tree is created.  This is useful for large datasets. (progress=FALSE)}

\item{rotate}{if TRUE then the data matrix X is uniformly randomly rotated. (rotate=FALSE)}
}
\value{
Tree
}
\description{
Creates a single decision tree based on an input matrix and class vector.  This is the function used by rerf to generate trees.
}
