% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{pipe}
\alias{pipe}
\alias{\%C\%}
\title{A cache-aware pipe that does not mask with \%>\%}
\usage{
lhs \%C\% rhs
}
\arguments{
\item{lhs}{A value or the magrittr placeholder.}

\item{rhs}{A function call using the magrittr semantics.}
}
\description{
This pipe can only be used at the start of a pipe chain, and must
be preceeded by \code{Cache(...)} to allow other Cache arguments to be passed.
}
\details{
This will take the input arguments of the
first function immediately following the \code{Cache() \%C\%} and the
entire pipe chain code, evaluate them both
against the \code{cacheRepo} argument in \code{Cache}. If they exist, then
the entire pipe chain will be skipped, and only the previous final result
will be given. If there is no previous cached copy of the initial function's
arguments, then all chain elements will be evaluated. The final result will
be cached for future use. The entire chain must be identical, therefore.
The required usage should be straight forward to insert into existing code
that uses pipes (\code{Cache() \%C\% ... remaining pipes}.
}
\examples{
tmpdir <- file.path(tempdir(), "testCache")
checkPath(tmpdir, create = TRUE)
a <- rnorm(10, 16) \%>\%
     mean() \%>\%
     prod(., 6)
b <- Cache(cacheRepo = tmpdir) \%C\%
     rnorm(10, 16) \%>\%
     mean() \%>\%
     prod(., 6)
d <- Cache(cacheRepo = tmpdir) \%C\%
     rnorm(10, 16) \%>\%
     mean() \%>\%
     prod(., 6)
e <- Cache(cacheRepo = tmpdir) \%C\%
     rnorm(10, 16) \%>\%
     mean() \%>\%
     prod(., 5) # changed
all.equal(b,d) # TRUE
all.equal(a,d) # different because 'a' uses a unique rnorm, 'd' uses the Cached rnorm
               #   because the arguments to rnorm, i.e., 10 and 16, and
               #   the subsequent functions in the chain, are identical
all.equal(a,e) # different because the final function, prod, has a changed argument.

unlink(tmpdir, recursive = TRUE)
}
\seealso{
pipe2
}
