% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{covsum}
\alias{covsum}
\title{Get covariate summary dataframe}
\usage{
covsum(
  data,
  covs,
  maincov = NULL,
  digits = 1,
  numobs = NULL,
  markup = TRUE,
  sanitize = TRUE,
  nicenames = TRUE,
  IQR = FALSE,
  all.stats = FALSE,
  pvalue = TRUE,
  show.tests = FALSE,
  excludeLevels = NULL,
  full = TRUE,
  digits.cat = 0,
  testcont = c("rank-sum test", "ANOVA"),
  testcat = c("Chi-squared", "Fisher"),
  include_missing = FALSE,
  percentage = c("column", "row")
)
}
\arguments{
\item{data}{dataframe containing data}

\item{covs}{character vector with the names of columns to include in table}

\item{maincov}{covariate to stratify table by}

\item{digits}{number of digits for summarizing mean data, does not affect
p-values}

\item{numobs}{named list overriding the number of people you expect to have
the covariate}

\item{markup}{boolean indicating if you want latex markup}

\item{sanitize}{boolean indicating if you want to sanitize all strings to not
break LaTeX}

\item{nicenames}{boolean indicating if you want to replace . and _ in strings
with a space}

\item{IQR}{boolean indicating if you want to display the inter quantile range
(Q1,Q3) as opposed to (min,max) in the summary for continuous variables}

\item{all.stats}{boolean indicating if all summary statistics (Q1,Q3 +
min,max on a separate line) should be displayed. Overrides IQR.}

\item{pvalue}{boolean indicating if you want p-values included in the table}

\item{show.tests}{boolean indicating if the type of statistical used should
be shown in a column beside the pvalues. Ignored if pvalue=FALSE.}

\item{excludeLevels}{a named list of covariate levels to exclude from
statistical tests in the form list(varname =c('level1','level2')). These
levels will be excluded from association tests, but not the table. This can
be useful for levels where there is a logical skip (ie not missing, but not
presented). Ignored if pvalue=FALSE.}

\item{full}{boolean indicating if you want the full sample included in the
table, ignored if maincov is NULL}

\item{digits.cat}{number of digits for the proportions when summarizing
categorical data (default: 0)}

\item{testcont}{test of choice for continuous variables,one of
\emph{rank-sum} (default) or \emph{ANOVA}}

\item{testcat}{test of choice for categorical variables,one of
\emph{Chi-squared} (default) or \emph{Fisher}}

\item{include_missing}{Option to include NA values of maincov. NAs will not
be included in statistical tests}

\item{percentage}{choice of how percentages are presented ,one of
\emph{column} (default) or \emph{row}}
}
\description{
Returns a dataframe corresponding to a descriptive table.
}
\details{
Comparisons for categorical variables default to chi-square tests, but if
there are counts of <5 then the Fisher Exact test will be used and if this is
unsuccessful then a second attempt will be made computing p-values using MC
simulation. If testcont='ANOVA' then the t-test with unequal variance will be
used for two groups and an ANOVA will be used for three or more. The
statistical test used can be displayed by specifying show.tests=TRUE.

The number of decimals places to display the statistics can be changed with
digits, but this will not change the display of p-values. If more significant
digits are required for p-values then use tableOnly=TRUE and format as
desired.
}
\seealso{
\code{\link{fisher.test}},\code{\link{chisq.test}},
\code{\link{wilcox.test}},\code{\link{kruskal.test}},and
\code{\link{anova}}
}
\keyword{dataframe}
