% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.aov.R
\name{report.aov}
\alias{report.aov}
\alias{report_effectsize.aov}
\alias{report_table.aov}
\alias{report_statistics.aov}
\alias{report_parameters.aov}
\alias{report_model.aov}
\alias{report_info.aov}
\alias{report_text.aov}
\title{Reporting ANOVAs}
\usage{
\method{report}{aov}(x, ...)

\method{report_effectsize}{aov}(x, ...)

\method{report_table}{aov}(x, ...)

\method{report_statistics}{aov}(x, table = NULL, ...)

\method{report_parameters}{aov}(x, ...)

\method{report_model}{aov}(x, table = NULL, ...)

\method{report_info}{aov}(x, effectsize = NULL, ...)

\method{report_text}{aov}(x, table = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{aov}, \code{anova} or \code{aovlist}.}

\item{...}{Arguments passed to or from other methods.}

\item{table}{Provide the output of  \code{report_table()} to avoid its
re-computation.}

\item{effectsize}{Provide the output of \code{report_effectsize()} to avoid
its re-computation.}
}
\value{
An object of class \code{\link{report}}.
}
\description{
Create reports for ANOVA models.
}
\examples{
data <- iris
data$Cat1 <- rep(c("A", "B"), length.out = nrow(data))

model <- aov(Sepal.Length ~ Species * Cat1, data = data)
r <- report(model)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
  \item \code{\link{report_table}}
  \item \code{\link{report_parameters}}
  \item \code{\link{report_statistics}}
  \item \code{\link{report_effectsize}}
  \item \code{\link{report_model}}
  \item \code{\link{report_priors}}
  \item \code{\link{report_random}}
  \item \code{\link{report_performance}}
  \item \code{\link{report_info}}
  \item \code{\link{report_text}}
}
Other types of reports:
\itemize{
  \item \code{\link{report_system}}
  \item \code{\link{report_packages}}
  \item \code{\link{report_participants}}
  \item \code{\link{report_sample}}
  \item \code{\link{report_date}}
}
Methods:
\itemize{
  \item \code{\link{as.report}}
}
Template file for supporting new models:
\itemize{
  \item \code{\link{report.default}}
}
}
