% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_snapshot.R
\name{cran_date}
\alias{cran_date}
\alias{cran_session}
\title{Estimate CRAN's date of packages}
\usage{
cran_date(versions)

cran_session(session = sessionInfo())
}
\arguments{
\item{versions}{A data.frame with the packages names and versions}

\item{session}{Session information.}
}
\value{
Last installation date from CRAN.
}
\description{
Check which CRAN dates are possible for a given packages and versions.
}
\examples{
# ip <- installed.packages()
ip <- data.frame(Package = c("A3", "AER"), Version = c("1.0.0", "1.2-15"))
cran_date(ip)
cran_session()
}
\seealso{
Other utilities: 
\code{\link{cran_doom}()},
\code{\link{cran_snapshot}()},
\code{\link{duplicated_alias}()},
\code{\link{package_date}()},
\code{\link{package_repos}()},
\code{\link{repos_dependencies}()},
\code{\link{update_dependencies}()}
}
\concept{utilities}
