% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/parse_pubmed_xml.r
\name{parse_pubmed_xml}
\alias{parse_pubmed_xml}
\title{Summarise an XML record from pubmed.}
\usage{
parse_pubmed_xml(raw_xml)
}
\arguments{
\item{raw_xml}{character the record to be parsed (as a character,
expected to come from \code{\link{entrez_fetch}})}
}
\value{
Either a single pubmed_record object, or a list of several
}
\description{
Summarise an XML record from pubmed.
}
\examples{
hox_paper <- entrez_search(db="pubmed", term="10.1038/nature08789[doi]")
hox_rel <- entrez_link(db="pubmed", dbfrom="pubmed", id=hox_paper$ids)
recs <- entrez_fetch(db="pubmed",
                       id=hox_rel$pubmed_pubmed[1:3],
                       rettype="xml")
parse_pubmed_xml(recs)
}

