% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-github.R
\name{install_github}
\alias{install_github}
\title{Attempts to install a package directly from GitHub.}
\usage{
install_github(
  repo,
  ref = "HEAD",
  subdir = NULL,
  auth_token = github_pat(quiet),
  host = "api.github.com",
  dependencies = NA,
  upgrade = c("default", "ask", "always", "never"),
  force = FALSE,
  quiet = FALSE,
  build = TRUE,
  build_opts = c("--no-resave-data", "--no-manual", "--no-build-vignettes"),
  build_manual = FALSE,
  build_vignettes = FALSE,
  repos = getOption("repos"),
  type = getOption("pkgType"),
  ...
)
}
\arguments{
\item{repo}{Repository address in the format
\verb{username/repo[/subdir][@ref|#pull|@*release]}. Alternatively, you can
specify \code{subdir} and/or \code{ref} using the respective parameters
(see below); if both are specified, the values in \code{repo} take
precedence.}

\item{ref}{Desired git reference. Could be a commit, tag, or branch
name, or a call to \code{\link[=github_pull]{github_pull()}} or \code{\link[=github_release]{github_release()}}. Defaults to
\code{"HEAD"}, which means the default branch on GitHub and for git remotes.
See \href{https://help.github.com/en/github/administering-a-repository/setting-the-default-branch}{setting-the-default-branch}
for more details.}

\item{subdir}{Subdirectory within repo that contains the R package.}

\item{auth_token}{To install from a private repo, generate a personal
access token (PAT) in "https://github.com/settings/tokens" and
supply to this argument. This is safer than using a password because
you can easily delete a PAT without affecting any others. Defaults to
the \code{GITHUB_PAT} environment variable.}

\item{host}{GitHub API host to use. Override with your GitHub enterprise
hostname, for example, \code{"github.hostname.com/api/v3"}.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).

The value "soft" means the same as \code{TRUE}, "hard" means the same as \code{NA}.

You can also specify dependencies from one or more additional fields,
common ones include:
\itemize{
\item Config/Needs/website - for dependencies used in building the pkgdown site.
\item Config/Needs/coverage for dependencies used in calculating test coverage.
}}

\item{upgrade}{Should package dependencies be upgraded? One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \verb{R CMD build}, only used when \code{build} is \code{TRUE}.}

\item{build_manual}{If \code{FALSE}, don't build PDF manual ('--no-manual').}

\item{build_vignettes}{If \code{FALSE}, don't build package vignettes ('--no-build-vignettes').}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.}

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This function is vectorised on \code{repo} so you can install multiple
packages in a single command.
}
\details{
If the repository uses submodules a command-line git client is required to
clone the submodules.
}
\examples{
\dontrun{
install_github("klutometis/roxygen")
install_github("wch/ggplot2")
install_github(c("rstudio/httpuv", "rstudio/shiny"))
install_github(c("hadley/httr@v0.4", "klutometis/roxygen#142",
  "r-lib/roxygen2@*release", "mfrasca/r-logging/pkg"))

# To install from a private repo, use auth_token with a token
# from https://github.com/settings/tokens. You only need the
# repo scope. Best practice is to save your PAT in env var called
# GITHUB_PAT.
install_github("hadley/private", auth_token = "abc")

# To pass option arguments to `R CMD INSTALL` use `INSTALL_opts`. e.g. to
install a package with source references and tests
install_github("rstudio/shiny", INSTALL_opts = c("--with-keep.source", "--install-tests"))
}
}
\seealso{
\code{\link[=github_pull]{github_pull()}}

Other package installation: 
\code{\link{install_bioc}()},
\code{\link{install_bitbucket}()},
\code{\link{install_cran}()},
\code{\link{install_dev}()},
\code{\link{install_gitlab}()},
\code{\link{install_git}()},
\code{\link{install_local}()},
\code{\link{install_svn}()},
\code{\link{install_url}()},
\code{\link{install_version}()}
}
\concept{package installation}
