% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmed_cat.R
\name{xmed_cat}
\alias{xmed_cat}
\title{Function to performed exploratory mediation with categorical variables}
\usage{
xmed_cat(data, iv, mediators, dv, covariates = NULL, type = "lasso",
  nfolds = 10, epsilon = 0.001, seed = NULL)
}
\arguments{
\item{data}{Name of the dataset}

\item{iv}{Name of independent variable}

\item{mediators}{Name of mediators}

\item{dv}{Name of dependent variable}

\item{covariates}{Name of covariates to be included in model.}

\item{type}{What type of penalty. Options include lasso, ridge, and enet.}

\item{nfolds}{Number of cross-validation folds.}

\item{epsilon}{Threshold for determining whether effect is 0 or not.}

\item{seed}{Set seed to control CV results}
}
\description{
Function to performed exploratory mediation with categorical variables
}
\examples{
\dontrun{
# example
library(ISLR)
College1 = College[which(College$Private=="Yes"),]
Data = data.frame(scale(College1[c("Grad.Rate","Accept","Outstate","Room.Board","Books","Expend")]))
Data$Grad.Rate <- ifelse(Data$Grad.Rate > 0,1,0)
Data$Grad.Rate <- as.factor(Data$Grad.Rate)
#lavaan model with all mediators
model1 <-
 ' # direct effect (c_prime)
Grad.Rate ~ c_prime*Accept
# mediators
Outstate ~ a1*Accept
Room.Board ~ a2*Accept
Books ~ a3*Accept
Expend ~ a6*Accept
Grad.Rate ~ b1*Outstate + b2*Room.Board + b3*Books + b6*Expend
# indirect effects (a*b)
a1b1 := a1*b1
a2b2 := a2*b2
a3b3 := a3*b3
a6b6 := a6*b6
# total effect (c)
c := c_prime + (a1*b1) + (a2*b2) + (a3*b3) + (a6*b6)
'
#p-value approach using delta method standard errors
fit.delta = sem(model1,data=Data,fixed.x=TRUE,ordered="Grad.Rate")
summary(fit.delta)

#xmed_cat()

iv <- "Accept"
dv <- "Grad.Rate"
mediators <- c("Outstate","Room.Board","Books","Expend")

out <- xmed_cat(Data,iv,mediators,dv)
out
}
}
