% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_regsem.R
\name{cv_regsem}
\alias{cv_regsem}
\title{The main function that ties together and runs the models.}
\usage{
cv_regsem(model, n.lambda = 100, pars_pen = NULL, mult.start = FALSE,
  multi.iter = 10, jump = 0.002, lambda.start = 0, alpha = 0.5,
  type = "none", fit.ret = c("rmsea", "BIC"), fit.ret2 = "train",
  n.boot = 20, data = NULL, optMethod = "coord_desc", gradFun = "ram",
  hessFun = "none", test.cov = NULL, parallel = FALSE, ncore = 2,
  Start = "lavaan", subOpt = "nlminb", diff_par = NULL, LB = -Inf,
  UB = Inf, par.lim = c(-Inf, Inf), block = TRUE, full = TRUE,
  calc = "normal", max.iter = 2000, tol = 1e-05, solver = FALSE,
  quasi = FALSE, solver.maxit = 5, alpha.inc = FALSE, step = 0.1,
  momentum = FALSE, step.ratio = FALSE, nlminb.control = list(),
  warm.start = TRUE, missing = "listwise", ...)
}
\arguments{
\item{model}{lavaan output object.}

\item{n.lambda}{number of penalization values to test.}

\item{pars_pen}{parameter indicators to penalize.}

\item{mult.start}{Logical. Whether to use multi_optim() (TRUE) or
regsem() (FALSE).}

\item{multi.iter}{maximum number of random starts for multi_optim}

\item{jump}{Amount to increase penalization each iteration.}

\item{lambda.start}{What value to start the penalty at}

\item{alpha}{Mixing for elastic net}

\item{type}{Penalty type. Options include "none", "lasso", "ridge",
"enet" for the elastic net,
"alasso" for the adaptive lasso
and "diff_lasso". diff_lasso penalizes the discrepency between
parameter estimates and some pre-specified values. The values
to take the deviation from are specified in diff_par. Two methods for
sparser results than lasso are the smooth clipped absolute deviation,
"scad", and the minimum concave penalty, "mcp".}

\item{fit.ret}{Fit indices to return.}

\item{fit.ret2}{Return fits using only dataset "train" or bootstrap "boot"? Have to
do 2 sample CV manually.}

\item{n.boot}{Number of bootstrap samples if fit.ret2="boot"}

\item{data}{Optional dataframe. Only required for missing="fiml".}

\item{optMethod}{solver to use.}

\item{gradFun}{gradient function to use.}

\item{hessFun}{hessian function to use.}

\item{test.cov}{Covariance matrix from test dataset. Necessary for CV=T}

\item{parallel}{Logical. whether to parallelize the processes running models for all
values of lambda.}

\item{ncore}{Number of cores to use when parallel=TRUE}

\item{Start}{type of starting values to use.}

\item{subOpt}{type of optimization to use in the optimx package.}

\item{diff_par}{parameter values to deviate from.}

\item{LB}{lower bound vector.}

\item{UB}{upper bound vector}

\item{par.lim}{Vector of minimum and maximum parameter estimates. Used to
stop optimization and move to new starting values if violated.}

\item{block}{Whether to use block coordinate descent}

\item{full}{Whether to do full gradient descent or block}

\item{calc}{Type of calc function to use with means or not. Not recommended
for use.}

\item{max.iter}{Number of iterations for coordinate descent}

\item{tol}{Tolerance for coordinate descent}

\item{solver}{Whether to use solver for coord_desc}

\item{quasi}{Whether to use quasi-Newton}

\item{solver.maxit}{Max iterations for solver in coord_desc}

\item{alpha.inc}{Whether alpha should increase for coord_desc}

\item{step}{Step size}

\item{momentum}{Momentum for step sizes}

\item{step.ratio}{Ratio of step size between A and S. Logical}

\item{nlminb.control}{list of control values to pass to nlminb}

\item{warm.start}{Whether start values are based on previous iteration.
This is not recommended.}

\item{missing}{How to handle missing data. Current options are "listwise"
and "fiml".}

\item{...}{Any additional arguments to pass to regsem() or multi_optim().}
}
\description{
The main function that ties together and runs the models.
}
\examples{
\dontrun{
library(lavaan)
HS <- data.frame(scale(HolzingerSwineford1939[,7:15]))
mod <- '
f =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9
'
outt = cfa(mod,HS)

cv.out = cv_regsem(outt,type="ridge",gradFun="none",n.lambda=100)
}
}
\keyword{calc}
\keyword{optim}
