% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{redist.prep.polsbypopper}
\alias{redist.prep.polsbypopper}
\title{Prep Polsby Popper Perimeter Dataframe}
\usage{
redist.prep.polsbypopper(shp, planarize = 3857, perim_path, ncores = 1)
}
\arguments{
\item{shp}{A SpatialPolygonsDataFrame or sf object. Required unless "EdgesRemoved"
and "logSpanningTree" with adjacency provided.}

\item{planarize}{a number, indicating the CRS to project the shapefile to if
it is latitude-longitude based. Set to FALSE to avoid planarizing.}

\item{perim_path}{A path to save an Rds}

\item{ncores}{the number of cores to parallelize over}
}
\value{
A perimeter dataframe
}
\description{
Prep Polsby Popper Perimeter Dataframe
}
\examples{
data(fl25)
perim_df <- redist.prep.polsbypopper(shp = fl25)

}
