% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsg.R
\name{redist.crsg}
\alias{redist.crsg}
\title{Redistricting via Compact Random Seed and Grow Algorithm}
\usage{
redist.crsg(
  adj,
  total_pop,
  shp,
  ndists,
  pop_tol,
  verbose = TRUE,
  maxiter = 5000,
  adj.list,
  population,
  area,
  x_center,
  y_center,
  thresh
)
}
\arguments{
\item{adj}{List of length N, where N is the number of precincts.
Each list element is an integer vector indicating which precincts that precinct
is adjacent to.  It is assumed that precinct numbers start at 0.}

\item{total_pop}{numeric vector of length N, where N is the number of precincts.
Each element lists the population total of the corresponding precinct, and is
used to enforce pop_tol constraints.}

\item{shp}{An sf dataframe to compute area and centroids with.}

\item{ndists}{integer, the number of districts we want to partition the
precincts into.}

\item{pop_tol}{numeric, indicating how close district population targets have
to be to the target population before algorithm converges.  pop_tol=0.05 for
example means that all districts must be between 0.95 and 1.05 times the size
of target.pop in population size.}

\item{verbose}{boolean, indicating whether the time to run the algorithm is
printed.}

\item{maxiter}{integer, indicating maximum number of iterations to attempt
before convergence to population constraint fails.  If it fails once, it will
use a different set of start values and try again.  If it fails again,
redist.rsg() returns an object of all NAs, indicating that use of more
iterations may be advised. Default is 5000.}

\item{adj.list}{Deprecated, use adj. List of length N, where N is the number of precincts.
Each list element is an integer vector indicating which precincts that precinct
is adjacent to.  It is assumed that precinct numbers start at 0.}

\item{population}{Deprecated, use total_pop. numeric vector of length N, where N is the number of precincts.
Each element lists the population total of the corresponding precinct, and is
used to enforce population constraints.}

\item{area}{Deprecated, use shp. numeric vector of length N, where N is the number of precincts. Each
element is the area of the corresponding precinct.}

\item{x_center}{Deprecated, use shp. numeric vector of length N, where N is the number of precincts.
Each element is the x coordinate of the geographic centroid of the corresponding
precinct.}

\item{y_center}{Deprecated, use shp. numeric vector of length N, where N is the number of precincts.
Each element is the y coordinate of the geographic centroid of the corresponding
precinct.}

\item{thresh}{Deprecated, use pop_tol. numeric, indicating how close district population targets have
to be to the target population before algorithm converges.  thresh=0.05 for
example means that all districts must be between 0.95 and 1.05 times the size
of target.pop in population size.}
}
\value{
list, containing three objects containing the completed redistricting
plan.
\itemize{
\item{\code{plan}}{  A vector of length N, indicating the
district membership of each precinct.}
\item{\code{district_list}}{  A list of length Ndistrict.  Each list contains a
vector of the precincts in the respective district.}
\item{\code{district_pop}}{  A vector of length Ndistrict, containing the
population totals of the respective districts.}
}
}
\description{
\code{redist.crsg} generates redistricting plans using a random seed a grow
algorithm.  This is the compact districting algorithm described in Chen and
Rodden (2013).
}
\examples{
\dontrun{
data("fl25")
adj <- redist.adjacency(fl25)
area <- sf::st_area(fl25)
centers <- sf::st_coordinates(sf::st_centroid(fl25))
redist.crsg(adj = adj, total_pop = fl25$pop, shp = fl25, ndists = 2, pop_tol = .1)
}
}
\references{
Jowei Chen and Jonathan Rodden (2013) ``Unintentional
Gerrymandering: Political Geography and Electoral Bias in Legislatures.''
Quarterly Journal of Political Science. 8(3): 239-269.
}
\concept{simulate}
