% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsDagAssignmentMethods.R,
%   R/exportUserDagAssignments.R, R/importUserDagAssignments.R
\name{dagAssignmentMethods}
\alias{dagAssignmentMethods}
\alias{exportUserDagAssignments}
\alias{importUserDagAssignments}
\alias{exportUserDagAssignments.redcapApiConnection}
\alias{importUserDagAssignments.redcapApiConnection}
\title{Export and Import Users Assigned to Data Access Groups}
\usage{
exportUserDagAssignments(rcon, ...)

importUserDagAssignments(rcon, data, ...)

\method{exportUserDagAssignments}{redcapApiConnection}(
  rcon,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{importUserDagAssignments}{redcapApiConnection}(
  rcon,
  data,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{data}{\code{data.frame} with the columns \code{username} and
\code{redcap_data_access_group}. The should only be one row per
user name.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportUserDagAssignments} method returns a data frame with two columns:\tabular{ll}{
    \tab  \cr
   \code{username} \tab The unique user name for each user in the project. \cr
   \code{redcap_data_access_group} \tab The unique Data Access Group name to which the user is assigned. \cr
}


\code{importUserDagAssignments} has no return and prints a message indicating the number
of assignments imported.
}
\description{
These methods enable the user to export existing assignments
of users to Data Access Groups, or import new or updated assignments
to the project.
}
\details{
When modifying existing assignments using the import method,
the user must provide the
unique user name and the group name. If the \code{redcap_data_access_group}
column is not provided, the REDCap user will not be assigned to any group.
}
\section{Functions}{
\itemize{
\item \code{exportUserDagAssignments()}: Export current User-DAG Assignments

\item \code{importUserDagAssignments()}: Import new or modified User-DAG Assignments.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Export the current assignments
exportUserDagAssignments(rcon)

# Assign a user to a Data Access Group
ForImport <- data.frame(username = "user1", 
                        redcap_data_access_group = "facility_one")
importUserDagAssigments(rcon, 
                        data = ForImport)
                                          
# Assign a multiple users to a Data Access Group
ForImport <- data.frame(username = c("user1", "user2", "user3"), 
                        redcap_data_access_group = c("facility_one", 
                                                     "facility_one", 
                                                      "facility_two"))
importUserDagAssigments(rcon, 
                        data = ForImport)
                        
# Remove a user from all Data Access Groups
ForImport <- data.frame(username = "user1", 
                        redcap_data_access_group = NA_character_)
importUserDagAssigments(rcon, 
                        data = ForImport)
}
}
\seealso{
\code{\link[=exportDags]{exportDags()}},\cr
\code{\link[=importDags]{importDags()}},\cr
\code{\link[=deleteDags]{deleteDags()}},\cr
\code{\link[=switchDag]{switchDag()}}
}
