#' @name exportSurveyParticipants
#' @title Exports details of participants for a given survey
#' @description Retrieving dataframe of survey participants managed in REDCap
#' @param rcon A REDCap connection object as generated by \code{redcapConnection}.
#' @param instrument A string type holding the name of "instrument" or survey the participants are managed under
#' @param event A string type holding the name of the event that the instrument belongs to
#' @param error_handling An option for how to handle errors returned by the API.
#'   see \code{\link{redcap_error}}
#' @param ... additional arguments to pass to other methods.
#' 
#' @details REDCap allows the user to manage a list of participants (if they are known) for each survey. This function 
#' pulls this information into a dataframe. The contents of the dataframe are the contact fields of the participants, 
#' the link to the survey for that participant if the participant hasn't completed the survey yet (otherwise, NA), 
#' the participants record id, and other information.
#' 
#' @author Paddy Tobias
#' @export

exportSurveyParticipants <- function(rcon, instrument, event, ...){
  UseMethod("exportSurveyParticipants")
}

#' @rdname exportSurveyParticipants
#' @export

exportSurveyParticipants.redcapDbConnection <- function(rcon, instrument, event, ...){
  message("Please accept my apologies.  The importArms method for redcapDbConnection objects\n",
          "has not yet been written.  Please consider using the API.")
}

#' @rdname exportSurveyParticipants
#' @export

exportSurveyParticipants.redcapApiConnection <- function(rcon, instrument, event, ...,
                                    error_handling = getOption("redcap_error_handling")){
  .params <- list(token=rcon$token, 
                  instrument = instrument,
                  event = event,
                  content='participantList',
                  format='csv', returnFormat='csv')
  
  x <- httr::POST(url=rcon$url, 
                  body=.params, 
                  config=rcon$config)
  
  if (x$status_code != 200) return(redcap_error(x, error_handling))
  
  x <- utils::read.csv(textConnection(as.character(x)), 
                       stringsAsFactors=FALSE, 
                       na.strings="")

  return(x)
}
