\name{deleteFiles}
\alias{deleteFiles}
\alias{deleteFiles.redcapDbConnection}
\alias{deleteFiles.redcapApiConnection}
\title{Deletes a File attached to a Record}
\description{This function allows you to remove a document that has been attached to an individual record}

\usage{
\method{deleteFiles}{redcapDbConnection}(rcon, record, field, event, ...)
\method{deleteFiles}{redcapApiConnection}(rcon, record, field, event, ..., 
    proj=NULL)
}


\arguments{
  \item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}
  \item{record}{The record ID in which the desired file is stored. Must be length 1.}
  \item{field}{The field name in which the file is stored. Must be length 1.}
  \item{event}{The event name for the file.  Must be length 1.  This applies only to longitudinal projects.  
    If the event is not
    supplied for a longitudinal project, the API will return an error message.}
  \item{proj}{A \code{redcapProject} object as created by \code{redcapProjectInfo}.}
   \item{...}{Arguments to be passed to other methods}
}

\author{Benjamin Nutter}

\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}

\examples{
\dontrun{
> #*** Note: I cannot provide working examples without
> #*** compromising security.  Instead, I will try to 
> #*** offer up sample code with the matching results
> 
> #*** Create the connection object
> rcon <- redcapConnection(url=[YOUR_REDCAP_URL], token=[API_TOKEN])
> 
>
> #* Delete a file
> deleteFiles(rcon, record=1, field="file_upload", event="event_1_arm_1")
The file was successfully deleted
>
}
}

\keyword{ methods }
