% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{step_other}
\alias{step_other}
\alias{tidy.step_other}
\title{Collapse Some Categorical Levels}
\usage{
step_other(recipe, ..., role = NA, trained = FALSE, threshold = 0.05,
  other = "other", objects = NULL, skip = FALSE)

\method{tidy}{step_other}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables that will potentially be reduced. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{threshold}{A single numeric value between 0 (inclusive)
and 1 for pooling. Factor levels whose rate of occurrence in
the training set are below \code{threshold} will be "othered".}

\item{other}{A single character value for the "other" category.}

\item{objects}{A list of objects that contain the information
to pool infrequent levels that is determined by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{x}{A \code{step_other} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
columns that will be affected) and \code{retained} (the factor
levels that were not pulled into "other")
}
\description{
\code{step_other} creates a \emph{specification} of a recipe
step that will potentially pool infrequently occurring values
into an "other" category.
}
\details{
The overall proportion of the categories are computed. The "other"
category is used in place of any categorical levels whose individual
proportion in the training set is less than \code{threshold}.

If no pooling is done the data are unmodified (although character data may
be changed to factors based on the value of \code{stringsAsFactors} in
\code{\link[=prep.recipe]{prep.recipe()}}). Otherwise, a factor is always returned with
different factor levels.

If \code{threshold} is less than the largest category proportion, all levels
except for the most frequent are collapsed to the \code{other} level.

If the retained categories include the value of \code{other}, an error is
thrown. If \code{other} is in the list of discarded levels, no error
occurs.

When data to be processed contains novel levels (i.e., not
contained in the training set), the other category is assigned.
}
\examples{
data(okc)

set.seed(19)
in_train <- sample(1:nrow(okc), size = 30000)

okc_tr <- okc[ in_train,]
okc_te <- okc[-in_train,]

rec <- recipe(~ diet + location, data = okc_tr)


rec <- rec \%>\%
  step_other(diet, location, threshold = .1, other = "other values")
rec <- prep(rec, training = okc_tr)

collapsed <- bake(rec, okc_te)
table(okc_te$diet, collapsed$diet, useNA = "always")

tidy(rec, number = 1)

# novel levels are also "othered"
tahiti <- okc[1,]
tahiti$location <- "a magical place"
bake(rec, tahiti)
}
\seealso{
\code{\link[=step_factor2string]{step_factor2string()}}, \code{\link[=step_string2factor]{step_string2factor()}},
\code{\link[=dummy_names]{dummy_names()}}, \code{\link[=step_regex]{step_regex()}}, \code{\link[=step_count]{step_count()}},
\code{\link[=step_ordinalscore]{step_ordinalscore()}}, \code{\link[=step_unorder]{step_unorder()}}, \code{\link[=step_novel]{step_novel()}}
}
\concept{
preprocessing factors
}
\keyword{datagen}
