% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{step_normalize}
\alias{step_normalize}
\alias{tidy.step_normalize}
\title{Center and scale numeric data}
\usage{
step_normalize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  means = NULL,
  sds = NULL,
  na_rm = TRUE,
  skip = FALSE,
  id = rand_id("normalize")
)

\method{tidy}{step_normalize}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{means}{A named numeric vector of means. This is
\code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{sds}{A named numeric vector of standard deviations This
is \code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{na_rm}{A logical value indicating whether \code{NA}
values should be removed when computing the standard deviation and mean.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_normalize} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected), \code{value} (the
standard deviations and means), and \code{statistic} for the type of value.
}
\description{
\code{step_normalize} creates a \emph{specification} of a recipe
step that will normalize numeric data to have a standard
deviation of one and a mean of zero.
}
\details{
Centering data means that the average of a variable is subtracted
from the data. Scaling data means that the standard deviation of a variable
is divided out of the data. \code{step_normalize} estimates the variable standard
deviations and means from the data used in the \code{training} argument of
\code{prep.recipe}. \code{bake.recipe} then applies the scaling to new data sets using
these estimates.
}
\examples{
library(modeldata)
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

norm_trans <- rec \%>\%
  step_normalize(carbon, hydrogen)

norm_obj <- prep(norm_trans, training = biomass_tr)

transformed_te <- bake(norm_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te
tidy(norm_trans, number = 1)
tidy(norm_obj, number = 1)

# To keep the original variables in the output, use `step_mutate_at`:
norm_keep_orig <- rec \%>\%
  step_mutate_at(all_numeric_predictors(), fn = list(orig = ~.)) \%>\%
  step_normalize(-contains("orig"), -all_outcomes())

keep_orig_obj <- prep(norm_keep_orig, training = biomass_tr)
keep_orig_te <- bake(keep_orig_obj, biomass_te)
keep_orig_te

}
\concept{normalization_methods}
\concept{preprocessing}
\keyword{datagen}
