% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternation.R
\name{or}
\alias{\%|\%}
\alias{or}
\alias{or1}
\title{Alternation}
\usage{
or(..., capture = FALSE)

x \%|\% y

or1(x, capture = FALSE)
}
\arguments{
\item{...}{Character vectors.}

\item{capture}{A logical value indicating whether or not the result should be
captured.  See note.}

\item{x}{A character vector.}

\item{y}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match one string or another.
}
\note{
\code{or} takes multiple character vector inputs and returns a
character vector of the inputs separated by pipes. \code{\%|\%} is an operator
interface to this function. \code{or1} takes a single character vector and
returns a string collapsed by pipes.

When \code{capture} is \code{TRUE}, the values are wrapped in a capture
group (see \code{\link{capture}}).  When \code{capture} is \code{FALSE} (the
default for \code{or} and \code{or1}), the values are wrapped in a
non-capture group (see \code{\link{token}}).  When \code{capture} is
\code{NA}, (the case for \code{\%|\%}) the values are not wrapped in
anything.
}
\examples{
# or takes an arbitrary number of arguments and groups them without capture
# Notice the recycling of inputs
or(letters, month.abb, "foo")

# or1 takes a single character vector
or1(c(letters, month.abb, "foo")) # Not the same as before!

# Capture the group
or1(letters, capture = TRUE)

# Don't create a group
or1(letters, capture = NA)

# The pipe operator doesn't group
letters \%|\% month.abb \%|\% "foo"

# Usage
(rx <- or("dog", "cat", "hippopotamus"))
stringi::stri_detect_regex(c("boondoggle", "caterwaul", "water-horse"), rx)
}
\references{
\url{http://www.regular-expressions.info/alternation.html}
}
\seealso{
\code{\link[base]{paste}}
}

