% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WTM.R
\name{WTM}
\alias{WTM}
\alias{dWTM}
\alias{pWTM}
\alias{rWTM}
\title{Weibull Threshold Model}
\usage{
dWTM(rt, resp, phi, x_res = "default", t_res = "default")

pWTM(rt, resp, phi, x_res = "default", t_res = "default")

rWTM(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Stimulus strength (\eqn{\mu}). Strength of the stimulus and used to set the drift
rate. For changing threshold models \eqn{v(x,t) = \mu}.
\item Noise scale (\eqn{\sigma}). Model noise scale parameter.
\item Initial decision threshold location (\eqn{b_0}). Sets the location of each decision
threshold at time \eqn{t = 0}.
\item Log10-decision threshold scale (\eqn{log_{10}(\lambda)}). Sets the approximate time for threshold
collapse or rise.
\item Log10-decision threshold shape (\eqn{log_{10}(\kappa)}). Sets the threshold shape. \eqn{\kappa > 1} produces
logistic-like thresholds, \eqn{\kappa < 1} produces exponential-like thresholds.
\item Collapse parameter (\eqn{c}). Sets the amount of collapse. \eqn{c = -1} gives collapse to
zero, \eqn{c = 1} gives no collapse, and \eqn{c > 1} gives rise.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
SDDM with thresholds that change with time. Thresholds are Weibull functions of the
form \eqn{b_u(t) = -b_l(t) = b_0 - b_0*(1 – c)*[1 - exp(-(t/\lambda)^{\kappa})].}
}
\examples{
# Probability density function
dWTM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.2, 0.5, -1.0, 0.0, 0.0, 1.0))

# Cumulative distribution function
pWTM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.2, 0.5, -1.0, 0.0, 0.0, 1.0))

# Random sampling
rWTM(n = 100, phi = c(0.3, 0.5, 1.0, 1.0, 1.5, 0.2, 0.5, -1.0, 0.0, 0.0, 1.0),
     dt = 0.0001)
}
\references{
Hawkins, G. E., Forstmann, B. U., Wagenmakers, E.-J., Ratcliff, R., & Brown, S. D. (2015).
Revisiting the Evidence for Collapsing Boundaries and Urgency Signals in Perceptual
Decision-Making. \emph{The Journal of Neuroscience, 35}(6), 2476-2484.

Palestro, J. J., Weichart, E., Sederberg, P. B., & Turner, B. M. (2018). Some task demands
induce collapsing bounds: Evidence from a behavioral analysis. \emph{Psychonomic
Bulletin & Review, 25}(4), 1225-1248.
}
\author{
Raphael Hartmann & Matthew Murrow
}
