% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparers.R
\name{ignore_differences}
\alias{ignore_differences}
\alias{identical_or_TRUE}
\alias{maps_identical_or_TRUE}
\title{Example Object and Side Effect Comparers}
\usage{
ignore_differences(x, y)

identical_or_TRUE(x, y)

maps_identical_or_TRUE(x, y)
}
\arguments{
\item{x}{prototype or part thereof}

\item{y}{object under scrutiny or part thereof}
}
\value{
Each comparer should yield \code{TRUE} if the test condition
is considered met or anything else otherwise.
However, it is highly recommended that in the latter case,
a single string with a short
summary of the differences is returned, as in \code{\link[base]{all.equal}}.
}
\description{
Two-argument functions to compare direct or indirect effects
of two test descriptors (see \code{\link{P}} and \code{\link{R}}).
These can be passed as \code{value_comparer} and \code{sides_comparer}
to \code{\link{E}}.
}
\details{
Notable built-in (base R) comparers include \code{\link[base]{identical}}
(the strictest possible)
and \code{\link[base]{all.equal}} (can ignore, amongst others,
round-off errors).

\code{ignore_differences} is a dummy comparer that always returns
\code{TRUE}. Hence, it does not discriminate between anything.

\code{identical_or_TRUE} is useful when comparing particular side effects,
where is assumed that a value \code{TRUE} represents the occurrence
of a condition, but without going into any details
(e.g., some warning).

\code{maps_identical_or_TRUE} propagates \code{identical_or_TRUE}
on each element of a given named list (treated as an unordered set
of key-value pairs) and aggregates the results.

You can define any comparer of your own liking:
the possibilities are endless. For example:
\itemize{
\item a comparer for side effects based on regular expressions,
\item a comparer that tests whether all elements in a vector are
    equal to \code{TRUE},
\item a comparer that verifies whether each element falls into
    a specified interval,
\item a comparer that ignores all the object attributes (possibly
    in combination with other comparers),
}
and so forth.
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}
}
