% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readtext_options.R
\name{readtext_options}
\alias{readtext_options}
\title{Get or set package options for readtext}
\usage{
readtext_options(..., reset = FALSE, initialize = FALSE)
}
\arguments{
\item{...}{options to be set, as key-value pair, same as
\code{\link{options}}. This may be a list of valid key-value pairs, useful
for setting a group of options at once (see examples).}

\item{reset}{logical; if \code{TRUE}, reset all \pkg{readtext} options to
their default values}

\item{initialize}{logical; if \code{TRUE}, reset only the \pkg{readtext}
options that are not already defined.  Used for setting initial values when
some have been defined previously, such as in `.Rprofile`.}
}
\value{
When called using a \code{key = value} pair (where \code{key} can be
a label or quoted character name)), the option is set and \code{TRUE} is
returned invisibly.

When called with no arguments, a named list of the package options is
returned.

When called with \code{reset = TRUE} as an argument, all arguments are
options are reset to their default values, and \code{TRUE} is returned
invisibly.
}
\description{
Get or set global options affecting functions across \pkg{readtext}.
}
\details{
Currently available options are: \describe{
\item{\code{verbosity}}{Default
  verbosity for messages produced when reading files.  See
  \code{\link{readtext}}.}
}
}
\examples{
\donttest{
# save the current options
(opt <- readtext_options())

# set higher verbosity
readtext_options(verbosity = 3)

# read something in here
if (!interactive()) pkgload::load_all()
DATA_DIR <- system.file("extdata/", package = "readtext")
readtext(paste0(DATA_DIR, "/txt/UDHR/*"))

# reset to saved options
readtext_options(opt)
}
}
