% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{guess_encoding}
\alias{guess_encoding}
\title{Guess encoding of file}
\usage{
guess_encoding(file, n_max = 10000, threshold = 0.2)
}
\arguments{
\item{file}{A character string specifying an input as specified in
\code{\link[=datasource]{datasource()}}, a raw vector, or a list of raw vectors.}

\item{n_max}{Number of lines to read. If \code{n_max} is -1, all lines in
file will be read.}

\item{threshold}{Only report guesses above this threshold of certainty.}
}
\value{
A tibble
}
\description{
Uses \code{\link[stringi:stri_enc_detect]{stringi::stri_enc_detect()}}: see the documentation there
for caveats.
}
\examples{
guess_encoding(readr_example("mtcars.csv"))
guess_encoding(read_lines_raw(readr_example("mtcars.csv")))
guess_encoding(read_file_raw(readr_example("mtcars.csv")))

guess_encoding("a\n\u00b5\u00b5")
}
