% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_delim_chunked.R
\name{melt_delim_chunked}
\alias{melt_delim_chunked}
\alias{melt_csv_chunked}
\alias{melt_csv2_chunked}
\alias{melt_tsv_chunked}
\title{Melt a delimited file by chunks}
\usage{
melt_delim_chunked(
  file,
  callback,
  chunk_size = 10000,
  delim,
  quote = "\\"",
  escape_backslash = FALSE,
  escape_double = TRUE,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  comment = "",
  trim_ws = FALSE,
  skip = 0,
  progress = show_progress(),
  skip_empty_rows = FALSE
)

melt_csv_chunked(
  file,
  callback,
  chunk_size = 10000,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  progress = show_progress(),
  skip_empty_rows = FALSE
)

melt_csv2_chunked(
  file,
  callback,
  chunk_size = 10000,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  progress = show_progress(),
  skip_empty_rows = FALSE
)

melt_tsv_chunked(
  file,
  callback,
  chunk_size = 10000,
  locale = default_locale(),
  na = c("", "NA"),
  quoted_na = TRUE,
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  skip = 0,
  progress = show_progress(),
  skip_empty_rows = FALSE
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as a
path, it must be wrapped with \code{I()}, be a string containing at least one
new line, or be a vector containing at least one string with a new line.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{callback}{A callback function to call on each chunk}

\item{chunk_size}{The number of rows to include in each chunk}

\item{delim}{Single character used to separate fields within a record.}

\item{quote}{Single character used to quote strings.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimiter character, the quote character, or
to add special characters like \verb{\\\\n}.}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value \verb{""""} represents
a single quote, \verb{\\"}.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quoted_na}{Should missing values inside quotes be treated as missing
values (the default) or strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace (ASCII spaces and tabs) be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data. If \code{comment} is
supplied any commented lines are ignored \emph{after} skipping.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The automatic
progress bar can be disabled by setting option \code{readr.show_progress} to
\code{FALSE}.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}
}
\description{
For certain non-rectangular data formats, it can be useful to parse the data
into a melted format where each row represents a single token.
}
\details{
\code{melt_delim_chunked()} and the specialisations \code{melt_csv_chunked()},
\code{melt_csv2_chunked()} and \code{melt_tsv_chunked()} read files by a chunk of rows
at a time, executing a given function on one chunk before reading the next.
}
\examples{
# Cars with 3 gears
f <- function(x, pos) subset(x, data_type == "integer")
melt_csv_chunked(readr_example("mtcars.csv"), DataFrameCallback$new(f), chunk_size = 5)
}
\seealso{
Other chunked: 
\code{\link{callback}},
\code{\link{read_delim_chunked}()},
\code{\link{read_lines_chunked}()}
}
\concept{chunked}
\keyword{internal}
